/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;

public class LobStoreInJar
implements LobStore {
    final int lobBlockSize;
    Database database;
    DataInputStream dataInput;
    final String fileName;
    long realPosition;

    public LobStoreInJar(Database database, int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.database = database;
        try {
            this.fileName = database.getPath() + ".lobs";
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            byte[] dataBytes = new byte[count];
            this.fileSeek(address);
            this.dataInput.readFully(dataBytes, 0, count);
            this.realPosition = address + (long)count;
            return dataBytes;
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, long position, int offset, int length) {
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public void setLength(long length) {
    }

    @Override
    public void close() {
        try {
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void synch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStream() throws IOException {
        if (this.dataInput != null) {
            this.dataInput.close();
        }
        InputStream fis = null;
        try {
            ClassLoader cl;
            fis = this.getClass().getResourceAsStream(this.fileName);
            if (fis == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                fis = cl.getResourceAsStream(this.fileName);
            }
        }
        catch (Throwable throwable) {
            if (fis == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        finally {
            if (fis == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        this.dataInput = new DataInputStream(fis);
        this.realPosition = 0L;
    }

    private void fileSeek(long position) throws IOException {
        long skipPosition;
        if (this.dataInput == null) {
            this.resetStream();
        }
        if (position < (skipPosition = this.realPosition)) {
            this.resetStream();
            skipPosition = 0L;
        }
        while (position > skipPosition) {
            skipPosition += this.dataInput.skip(position - skipPosition);
        }
        this.realPosition = position;
    }
}

