/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAVLDiskLarge;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL
implements PersistentStore {
    DataFileCache cache;
    RowOutputInterface rowOut;
    boolean largeData;
    ReadWriteLock lock;
    Lock readLock;
    Lock writeLock;

    public RowStoreAVLDisk(PersistentStoreCollection manager, DataFileCache cache, Table table) {
        this(manager, table);
        this.cache = cache;
        this.rowOut = cache.rowOut.duplicate();
        cache.adjustStoreCount(1);
        this.largeData = this.database.logger.propLargeData;
        this.tableSpace = cache.spaceManager.getTableSpace(table.getSpaceID());
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    protected RowStoreAVLDisk(PersistentStoreCollection manager, Table table) {
        this.database = table.database;
        this.manager = manager;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.largeData = this.database.logger.getDataFileFactor() > 1;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    @Override
    public void set(CachedObject object) {
        this.database.txManager.setTransactionInfo(this, object);
    }

    @Override
    public CachedObject get(long key) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, false);
        return object;
    }

    @Override
    public CachedObject get(long key, boolean keep) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, keep);
        return object;
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        object = this.cache.get(object, (PersistentStore)this, keep);
        return object;
    }

    @Override
    public void add(Session session, CachedObject object, boolean tx) {
        int size = object.getRealSize(this.rowOut);
        size += this.indexList.length * 16;
        size = this.rowOut.getStorageSize(size);
        object.setStorageSize(size);
        long pos = this.tableSpace.getFilePosition(size, false);
        object.setPos(pos);
        if (tx) {
            RowAction.addInsertAction(session, this.table, (Row)object);
            this.database.txManager.addTransactionInfo(object);
        }
        this.cache.add(object, false);
        this.storageSize += (long)size;
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        try {
            if (this.largeData) {
                return new RowAVLDiskLarge(this.table, in);
            }
            return new RowAVLDisk(this.table, in);
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        RowAVLDisk row = this.largeData ? new RowAVLDiskLarge(this.table, (Object[])object, this) : new RowAVLDisk(this.table, (Object[])object, this);
        this.add(session, row, tx);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Session session, Row row) {
        this.writeLock();
        try {
            super.delete(session, row);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        this.writeLock();
        try {
            row = (Row)this.get((CachedObject)row, true);
            super.indexRow(session, row);
        }
        catch (HsqlException e) {
            this.database.txManager.removeTransactionInfo(row);
            throw e;
        }
        finally {
            row.keepInMemory(false);
            this.writeUnlock();
        }
    }

    @Override
    public void removeAll() {
        this.elementCount.set(0L);
        this.cache.spaceManager.freeTableSpace(this.tableSpace.getSpaceID());
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject object) {
        this.cache.remove(object);
        this.tableSpace.release(object.getPos(), object.getStorageSize());
        this.storageSize -= (long)object.getStorageSize();
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public void postCommitAction(Session session, RowAction action) {
        if (action.getType() == 0) {
            this.database.txManager.removeTransactionInfo(action.getPos());
        } else if (action.getType() == 3 && !action.isDeleteComplete()) {
            action.setDeleteComplete();
            Row row = action.getRow();
            if (row == null) {
                row = (Row)this.get(action.getPos(), false);
            }
            this.delete(session, row);
            this.database.txManager.removeTransactionInfo(row);
            this.remove(row);
        }
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, data);
                if (txModel != 0) break;
                this.remove(row);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                if (txModel != 0) break;
                this.remove(row);
                break;
            }
            case 3: {
                throw Error.runtimeError(201, "RowStore");
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                row = (Row)this.get((CachedObject)row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row);
                break;
            }
            case 4: {
                if (txModel != 0) {
                    this.delete(session, row);
                    this.database.txManager.removeTransactionInfo(row);
                }
                this.remove(row);
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache cache) {
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void release() {
        this.cache.adjustStoreCount(-1);
        this.cache = null;
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public CachedObject getAccessor(Index key) {
        NodeAVL node = (NodeAVL)this.accessorList[key.getPosition()];
        if (node == null) {
            return null;
        }
        RowAVL row = (RowAVL)this.get((CachedObject)node.getRow(this), false);
        node = row.getNode(key.getPosition());
        this.accessorList[key.getPosition()] = node;
        return node;
    }

    @Override
    public void setAccessor(Index key, long accessor) {
        CachedObject object = this.get(accessor, false);
        if (object != null) {
            NodeAVL node = ((RowAVL)object).getNode(key.getPosition());
            object = node;
        }
        this.setAccessor(key, object);
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveDataToSpace(Session session) {
        Table table = (Table)this.table;
        long rowCount = this.elementCount();
        if (rowCount == 0L) {
            return;
        }
        if (rowCount > Integer.MAX_VALUE) {
            return;
        }
        DoubleIntIndex pointerLookup = new DoubleIntIndex((int)rowCount, false);
        pointerLookup.setKeysSearchTarget();
        this.writeLock();
        try {
            this.moveDataToSpace(this.cache, pointerLookup);
            CachedObject[] newAccessorList = new CachedObject[this.accessorList.length];
            for (int i = 0; i < this.accessorList.length; ++i) {
                long pos = pointerLookup.lookup(this.accessorList[i].getPos());
                newAccessorList[i] = this.cache.get(pos, (PersistentStore)this, false);
            }
            RowIterator it = this.rowIterator();
            while (it.hasNext()) {
                Row row = it.getNextRow();
                this.cache.remove(row);
                this.tableSpace.release(row.getPos(), row.getStorageSize());
            }
            this.accessorList = newAccessorList;
        }
        finally {
            this.writeUnlock();
        }
        this.database.logger.logDetailEvent("table written " + table.getName().name);
    }

    public void moveDataToSpace(DataFileCache targetCache, DoubleIntIndex pointerLookup) {
        long newPos;
        int spaceId = this.table.getSpaceID();
        TableSpaceManager targetSpace = targetCache.spaceManager.getTableSpace(spaceId);
        pointerLookup.setKeysSearchTarget();
        RowIterator it = this.indexList[0].firstRow(this);
        while (it.hasNext()) {
            Row row = it.getNextRow();
            pointerLookup.addUnsorted(row.getPos(), (long)row.getStorageSize());
        }
        pointerLookup.sort();
        for (int i = 0; i < pointerLookup.size(); ++i) {
            newPos = targetSpace.getFilePosition(pointerLookup.getValue(i), false);
            pointerLookup.setValue(i, (int)newPos);
        }
        it = this.indexList[0].firstRow(this);
        while (it.hasNext()) {
            Row row = it.getNextRow();
            newPos = pointerLookup.lookup(row.getPos());
            targetCache.rowOut.reset();
            row.write(targetCache.rowOut, pointerLookup);
            targetCache.saveRowOutput(newPos);
        }
    }

    long getStorageSizeEstimate() {
        if (this.elementCount.get() == 0L) {
            return 0L;
        }
        CachedObject accessor = this.getAccessor(this.indexList[0]);
        CachedObject row = this.get(accessor.getPos());
        return (long)row.getStorageSize() * this.elementCount.get();
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

