/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLMemory
extends RowStoreAVL
implements PersistentStore {
    Database database;
    AtomicInteger rowIdSequence = new AtomicInteger();
    ReadWriteLock lock;
    Lock readLock;
    Lock writeLock;

    public RowStoreAVLMemory(PersistentStoreCollection manager, Table table) {
        this.database = table.database;
        this.manager = manager;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public CachedObject get(long i) {
        throw Error.runtimeError(201, "RowStoreAVMemory");
    }

    @Override
    public CachedObject get(long i, boolean keep) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        return object;
    }

    @Override
    public void add(Session session, CachedObject object, boolean tx) {
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        int id = this.rowIdSequence.getAndIncrement();
        RowAVL row = new RowAVL(this.table, (Object[])object, id, this);
        if (tx) {
            RowAction.addInsertAction(session, this.table, row);
        }
        return row;
    }

    @Override
    public void removeAll() {
        this.destroy();
        this.setTimestamp(0L);
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject object) {
    }

    public void release(long i) {
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public void postCommitAction(Session session, RowAction action) {
        if (action.getType() == 3 && !action.isDeleteComplete()) {
            action.setDeleteComplete();
            Row row = action.getRow();
            this.delete(session, row);
        }
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, data);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                throw Error.runtimeError(201, "RowStore");
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 4: {
                this.remove(row);
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return null;
    }

    @Override
    public void setCache(DataFileCache cache) {
    }

    @Override
    public void release() {
        this.destroy();
        this.setTimestamp(0L);
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

