/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerBlocks
implements TableSpaceManager {
    DataSpaceManager spaceManager;
    private final int scale;
    final int mainBlockSize;
    final int spaceID;
    final int minReuse;
    private DoubleIntIndex lookup;
    private final int capacity;
    private long requestGetCount;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    boolean isModified;
    long freshBlockFreePos = 0L;
    long freshBlockLimit = 0L;
    int fileBlockIndex = -1;

    public TableSpaceManagerBlocks(DataSpaceManager spaceManager, int tableId, int fileBlockSize, int capacity, int fileScale, int minReuse) {
        this.spaceManager = spaceManager;
        this.scale = fileScale;
        this.spaceID = tableId;
        this.mainBlockSize = fileBlockSize;
        this.minReuse = minReuse;
        this.lookup = new DoubleIntIndex(capacity, true);
        this.lookup.setValuesSearchTarget();
        this.capacity = capacity;
    }

    @Override
    public boolean hasFileRoom(long blockSize) {
        return this.freshBlockLimit - this.freshBlockFreePos > blockSize;
    }

    @Override
    public void addFileBlock(long blockFreePos, long blockLimit) {
        int released = (int)(this.freshBlockLimit - this.freshBlockFreePos);
        if (released > 0) {
            this.release(this.freshBlockFreePos / (long)this.scale, released);
        }
        this.initialiseFileBlock(null, blockFreePos, blockLimit);
    }

    @Override
    public void initialiseFileBlock(DoubleIntIndex spaceList, long blockFreePos, long blockLimit) {
        this.freshBlockFreePos = blockFreePos;
        this.freshBlockLimit = blockLimit;
        if (spaceList != null) {
            spaceList.copyTo(this.lookup);
        }
    }

    boolean getNewMainBlock(long rowSize) {
        long blockCount = ((long)this.mainBlockSize + rowSize) / (long)this.mainBlockSize;
        long blockSize = blockCount * (long)this.mainBlockSize;
        long position = this.spaceManager.getFileBlocks(this.spaceID, (int)blockCount);
        if (position < 0L) {
            return false;
        }
        if (position != this.freshBlockLimit) {
            long released = this.freshBlockLimit - this.freshBlockFreePos;
            if (released > 0L) {
                this.release(this.freshBlockFreePos / (long)this.scale, (int)released);
            }
            this.freshBlockFreePos = position;
            this.freshBlockLimit = position;
        }
        this.freshBlockLimit += blockSize;
        return true;
    }

    long getNewBlock(long rowSize, boolean asBlocks) {
        long released;
        boolean result;
        if (asBlocks) {
            rowSize = (int)ArrayUtil.getBinaryMultipleCeiling(rowSize, 4096L);
        }
        if (this.freshBlockFreePos + rowSize > this.freshBlockLimit && !(result = this.getNewMainBlock(rowSize))) {
            throw Error.error(468);
        }
        long position = this.freshBlockFreePos;
        if (asBlocks && (released = (position = ArrayUtil.getBinaryMultipleCeiling(position, 4096L)) - this.freshBlockFreePos) > 0L) {
            this.release(this.freshBlockFreePos / (long)this.scale, (int)released);
            this.freshBlockFreePos = position;
        }
        this.freshBlockFreePos += rowSize;
        return position / (long)this.scale;
    }

    @Override
    public int getSpaceID() {
        return this.spaceID;
    }

    @Override
    public synchronized void release(long pos, int rowSize) {
        this.isModified = true;
        ++this.releaseCount;
        if (this.lookup.size() == this.capacity) {
            this.resetList();
        }
        if (pos >= Integer.MAX_VALUE) {
            return;
        }
        this.lookup.add(pos, (long)(rowSize / this.scale));
    }

    @Override
    public synchronized long getFilePosition(int rowSize, boolean asBlocks) {
        ++this.requestGetCount;
        if (this.capacity == 0) {
            return this.getNewBlock(rowSize, asBlocks);
        }
        if (asBlocks) {
            rowSize = (int)ArrayUtil.getBinaryMultipleCeiling(rowSize, 4096L);
        }
        int index = -1;
        int rowUnits = rowSize / this.scale;
        if (rowSize >= this.minReuse && this.lookup.size() > 0) {
            index = this.lookup.getValue(0) >= rowUnits ? 0 : (rowSize > Integer.MAX_VALUE ? -1 : this.lookup.findFirstGreaterEqualKeyIndex(rowUnits));
        }
        if (index == -1) {
            return this.getNewBlock(rowSize, asBlocks);
        }
        if (asBlocks) {
            long pos;
            while (index < this.lookup.size() && (pos = (long)this.lookup.getKey(index)) % (long)(4096 / this.scale) != 0L) {
                ++index;
            }
            if (index == this.lookup.size()) {
                return this.getNewBlock(rowSize, asBlocks);
            }
        }
        ++this.requestCount;
        this.requestSize += (long)rowSize;
        int key = this.lookup.getKey(index);
        int units = this.lookup.getValue(index);
        int difference = units - rowUnits;
        this.lookup.remove(index);
        if (difference > 0) {
            int pos = key + rowUnits;
            this.lookup.add(pos, difference);
        }
        return key;
    }

    @Override
    public void reset() {
        this.fileBlockIndex = this.freshBlockFreePos == 0L ? -1 : (int)(this.freshBlockFreePos / (long)this.mainBlockSize);
        this.spaceManager.freeTableSpace(this.spaceID, this.lookup, this.freshBlockFreePos, this.freshBlockLimit, true);
        this.freshBlockFreePos = 0L;
        this.freshBlockLimit = 0L;
    }

    @Override
    public long getLostBlocksSize() {
        long total = this.freshBlockLimit - this.freshBlockFreePos + this.lookup.getTotalValues() * (long)this.scale;
        return total;
    }

    @Override
    public boolean isDefaultSpace() {
        return this.spaceID == 7;
    }

    public int getFileBlockIndex() {
        return this.fileBlockIndex;
    }

    private void resetList() {
        this.spaceManager.freeTableSpace(this.spaceID, this.lookup, 0L, 0L, false);
    }
}

