/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerSimple
implements TableSpaceManager {
    DataFileCache cache;
    final int scale;

    public TableSpaceManagerSimple(DataFileCache cache) {
        this.cache = cache;
        this.scale = cache.getDataFileScale();
    }

    @Override
    public int getSpaceID() {
        return 7;
    }

    @Override
    public void release(long pos, int rowSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilePosition(int rowSize, boolean asBlocks) {
        this.cache.writeLock.lock();
        try {
            long position = this.cache.getFileFreePos() / (long)this.scale;
            long newFreePosition = this.cache.getFileFreePos() + (long)rowSize;
            if (newFreePosition > this.cache.maxDataFileSize) {
                this.cache.logSevereEvent("data file reached maximum size " + this.cache.dataFileName, null);
                throw Error.error(468);
            }
            this.cache.fileFreePosition = newFreePosition;
            long l = position;
            return l;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public boolean hasFileRoom(long blockSize) {
        return true;
    }

    @Override
    public void addFileBlock(long blockFreePos, long blockLimit) {
    }

    @Override
    public void initialiseFileBlock(DoubleIntIndex lookup, long blockFreePos, long blockLimit) {
    }

    @Override
    public void reset() {
    }

    @Override
    public long getLostBlocksSize() {
        return 0L;
    }

    @Override
    public boolean isDefaultSpace() {
        return true;
    }
}

