/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.result;

public class ResultProperties {
    static final int idx_returnable = 0;
    static final int idx_holdable = 1;
    static final int idx_scrollable = 2;
    static final int idx_updatable = 3;
    static final int idx_sensitive = 4;
    static final int idx_isheld = 5;
    public static final int defaultPropsValue = 0;
    public static final int updatablePropsValue = 8;

    public static int getProperties(int sensitive, int updatable, int scrollable, int holdable, int returnable) {
        int combined = sensitive << 4 | updatable << 3 | scrollable << 2 | holdable << 1 | returnable << 0;
        return combined;
    }

    public static int getJDBCHoldability(int props) {
        return ResultProperties.isHoldable(props) ? 1 : 2;
    }

    public static int getJDBCConcurrency(int props) {
        return ResultProperties.isReadOnly(props) ? 1007 : 1008;
    }

    public static int getJDBCScrollability(int props) {
        return ResultProperties.isScrollable(props) ? 1004 : 1003;
    }

    public static int getValueForJDBC(int type, int concurrency, int holdability) {
        int scrollable = type == 1003 ? 0 : 1;
        int updatable = concurrency == 1008 ? 1 : 0;
        int holdable = holdability == 1 ? 1 : 0;
        int prop = updatable << 3 | scrollable << 2 | holdable << 1;
        return prop;
    }

    public static boolean isUpdatable(int props) {
        return (props & 8) != 0;
    }

    public static boolean isScrollable(int props) {
        return (props & 4) != 0;
    }

    public static boolean isHoldable(int props) {
        return (props & 2) != 0;
    }

    public static boolean isSensitive(int props) {
        return (props & 0x10) != 0;
    }

    public static boolean isReadOnly(int props) {
        return (props & 8) == 0;
    }

    public static boolean isHeld(int props) {
        return (props & 0x20) != 0;
    }

    public static int addUpdatable(int props, boolean flag) {
        return flag ? props | 8 : props & 0xFFFFFFF7;
    }

    public static int addHoldable(int props, boolean flag) {
        return flag ? props | 2 : props & 0xFFFFFFFD;
    }

    public static int addScrollable(int props, boolean flag) {
        return flag ? props | 4 : props & 0xFFFFFFFB;
    }

    public static int addIsHeld(int props, boolean flag) {
        return flag ? props | 0x20 : props & 0xFFFFFFDF;
    }
}

