/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import org.hsqldb.Scanner;
import org.hsqldb.error.Error;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputText
extends RowInputBase
implements RowInputInterface {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    protected String text;
    protected int line;
    protected int field;
    protected int next = 0;
    protected boolean allQuoted;
    protected Scanner scanner;
    private int maxPooledStringLength = ValuePool.getMaxStringLength();

    public RowInputText(String fieldSep, String varSep, String longvarSep, boolean allQuoted) {
        super(new byte[0]);
        this.scanner = new Scanner();
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.allQuoted = allQuoted;
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.fieldSepLen = fieldSep.length();
        this.varSepLen = varSep.length();
        this.longvarSepLen = longvarSep.length();
    }

    public void setSource(String text, long pos, int byteSize) {
        this.size = byteSize;
        this.text = text;
        this.textLen = text.length();
        this.filePos = pos;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String sep, int sepLen, boolean isEnd) {
        String s = null;
        try {
            int start = this.next;
            ++this.field;
            if (isEnd) {
                if (this.next >= this.textLen && sepLen > 0) {
                    throw Error.error(488);
                }
                if (!this.text.endsWith(sep)) throw Error.error(488);
                this.next = this.textLen - sepLen;
            } else {
                this.next = this.text.indexOf(sep, start);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            if (start > this.next) {
                start = this.next;
            }
            s = this.text.substring(start, this.next);
            this.next += sepLen;
            int trimLength = s.trim().length();
            if (trimLength == 0) {
                return null;
            }
            if (trimLength >= s.length()) return s;
            trimLength = s.length() - 1;
            while (s.charAt(trimLength) < ' ') {
                --trimLength;
            }
            return s.substring(0, trimLength + 1);
        }
        catch (Exception e) {
            String message = e.toString();
            throw Error.error(e, 41, message);
        }
    }

    @Override
    public String readString() {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    @Override
    public char readChar() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public byte readByte() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public short readShort() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public int readInt() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public long readLong() {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public int readType() {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) {
        String s = null;
        switch (type.typeCode) {
            case 1: {
                s = this.readString();
                break;
            }
            case 12: {
                s = this.readVarString();
                break;
            }
            default: {
                s = this.readLongVarString();
            }
        }
        if (s == null) {
            return null;
        }
        if (s.length() > this.maxPooledStringLength) {
            return new String(s);
        }
        return ValuePool.getString(s);
    }

    @Override
    protected Integer readSmallint() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(s));
    }

    @Override
    protected Integer readInteger() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(s));
    }

    @Override
    protected Long readBigint() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getLong(Long.parseLong(s));
    }

    @Override
    protected Double readReal() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Double.valueOf(s);
    }

    @Override
    protected BigDecimal readDecimal(Type type) {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return new BigDecimal(s);
    }

    @Override
    protected TimeData readTime(Type type) {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTime(s);
    }

    @Override
    protected TimestampData readDate(Type type) {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newDate(s);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTimestamp(s);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval(s, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval(s, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object readOther() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        if (data.length(null) == 0L) {
            return null;
        }
        return new JavaObjectData(data.getBytes());
    }

    @Override
    protected BinaryData readBit() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBit(s);
        return data;
    }

    @Override
    protected BinaryData readBinary() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        return data;
    }

    @Override
    protected ClobData readClob() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        long id = Long.parseLong(s);
        return new ClobDataID(id);
    }

    @Override
    protected BlobData readBlob() {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        long id = Long.parseLong(s);
        return new BlobDataID(id);
    }

    @Override
    protected Object[] readArray(Type type) {
        throw Error.runtimeError(201, "RowInputText");
    }

    public int getLineNumber() {
        return this.line;
    }

    public void skippedLine() {
        ++this.line;
    }

    @Override
    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.filePos = 0L;
        this.next = 0;
        this.field = 0;
        this.line = 0;
    }
}

