/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.rowio.RowOutputTextLog;
import org.hsqldb.scriptio.ScriptWriterBase;

public class ScriptWriterText
extends ScriptWriterBase {
    RowOutputTextLog rowOut;
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static byte[] BYTES_LINE_SEP;
    static byte[] BYTES_COMMIT;
    static byte[] BYTES_INSERT_INTO;
    static byte[] BYTES_VALUES;
    static byte[] BYTES_TERM;
    static byte[] BYTES_DELETE_FROM;
    static byte[] BYTES_WHERE;
    static byte[] BYTES_SEQUENCE;
    static byte[] BYTES_SEQUENCE_MID;
    static byte[] BYTES_C_ID_INIT;
    static byte[] BYTES_C_ID_TERM;
    static byte[] BYTES_SCHEMA;

    public ScriptWriterText(Database db, OutputStream outputStream, FileAccess.FileSync descriptor, boolean includeCachedData) {
        super(db, outputStream, descriptor, includeCachedData);
    }

    public ScriptWriterText(Database db, String file, boolean includeCachedData, boolean newFile, boolean isDump) {
        super(db, file, includeCachedData, newFile, isDump);
    }

    public ScriptWriterText(Database db, String file, boolean includeCachedData, boolean compressed) {
        super(db, file, includeCachedData, true, false);
        if (compressed) {
            this.isCompressed = true;
            try {
                this.fileStreamOut = new GZIPOutputStream(this.fileStreamOut);
            }
            catch (IOException e) {
                throw Error.error(e, 452, 26, new Object[]{e.toString(), this.outFile});
            }
        }
    }

    @Override
    protected void initBuffers() {
        this.rowOut = new RowOutputTextLog();
    }

    @Override
    protected void writeDataTerm() throws IOException {
    }

    @Override
    protected void writeSessionIdAndSchema(Session session) throws IOException {
        if (session == null) {
            return;
        }
        if (session != this.currentSession) {
            this.rowOut.reset();
            this.rowOut.write(BYTES_C_ID_INIT);
            this.rowOut.writeLong(session.getId());
            this.rowOut.write(BYTES_C_ID_TERM);
            this.currentSession = session;
            this.writeRowOutToFile();
        }
        if (this.schemaToLog != session.loggedSchema) {
            this.rowOut.reset();
            this.writeSchemaStatement(this.schemaToLog);
            session.loggedSchema = this.schemaToLog;
            this.writeRowOutToFile();
        }
    }

    private void writeSchemaStatement(HsqlNameManager.HsqlName schema) {
        this.rowOut.write(BYTES_SCHEMA);
        this.rowOut.writeString(schema.statementName);
        this.rowOut.write(BYTES_LINE_SEP);
    }

    @Override
    public void writeLogStatement(Session session, String s) throws IOException {
        if (session != null) {
            this.schemaToLog = session.currentSchema;
            this.writeSessionIdAndSchema(session);
        }
        this.rowOut.reset();
        this.rowOut.writeString(s);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
    }

    @Override
    public void writeRow(Session session, Row row, Table table) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.setMode(0);
        this.rowOut.write(BYTES_INSERT_INTO);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_VALUES);
        this.rowOut.writeData(row, table.getColumnTypes());
        this.rowOut.write(BYTES_TERM);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
    }

    @Override
    public void writeTableInit(Table t) throws IOException {
        if (t.isEmpty(this.currentSession)) {
            return;
        }
        if (this.schemaToLog == this.currentSession.loggedSchema) {
            return;
        }
        this.rowOut.reset();
        this.writeSchemaStatement(t.getName().schema);
        this.writeRowOutToFile();
        this.currentSession.loggedSchema = this.schemaToLog;
    }

    @Override
    public void writeOtherStatement(Session session, String s) throws IOException {
        this.writeLogStatement(session, s);
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    public void writeInsertStatement(Session session, Row row, Table table) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.writeRow(session, row, table);
    }

    @Override
    public void writeDeleteStatement(Session session, Table table, Object[] data) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.setMode(1);
        this.rowOut.write(BYTES_DELETE_FROM);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_WHERE);
        this.rowOut.writeData(table.getColumnCount(), table.getColumnTypes(), data, table.columnList, table.getPrimaryKey());
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
    }

    @Override
    public void writeSequenceStatement(Session session, NumberSequence seq) throws IOException {
        this.schemaToLog = seq.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.write(BYTES_SEQUENCE);
        this.rowOut.writeString(seq.getSchemaName().statementName);
        this.rowOut.write(46);
        this.rowOut.writeString(seq.getName().statementName);
        this.rowOut.write(BYTES_SEQUENCE_MID);
        this.rowOut.writeLong(seq.peek());
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
    }

    @Override
    public void writeCommitStatement(Session session) throws IOException {
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.write(BYTES_COMMIT);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    protected void finishStream() throws IOException {
        if (this.isCompressed) {
            ((GZIPOutputStream)this.fileStreamOut).finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRowOutToFile() throws IOException {
        if (this.fileStreamOut == null) {
            return;
        }
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
            this.byteCount += (long)this.rowOut.size();
            ++this.lineCount;
        }
    }

    static {
        String sLineSep = System.getProperty("line.separator", "\n");
        try {
            BYTES_LINE_SEP = sLineSep.getBytes();
            BYTES_COMMIT = "COMMIT".getBytes(ISO_8859_1);
            BYTES_INSERT_INTO = "INSERT INTO ".getBytes(ISO_8859_1);
            BYTES_VALUES = " VALUES(".getBytes(ISO_8859_1);
            BYTES_TERM = ")".getBytes(ISO_8859_1);
            BYTES_DELETE_FROM = "DELETE FROM ".getBytes(ISO_8859_1);
            BYTES_WHERE = " WHERE ".getBytes(ISO_8859_1);
            BYTES_SEQUENCE = "ALTER SEQUENCE ".getBytes(ISO_8859_1);
            BYTES_SEQUENCE_MID = " RESTART WITH ".getBytes(ISO_8859_1);
            BYTES_C_ID_INIT = "/*C".getBytes(ISO_8859_1);
            BYTES_C_ID_TERM = "*/".getBytes(ISO_8859_1);
            BYTES_SCHEMA = "SET SCHEMA ".getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw Error.runtimeError(201, "ScriptWriterText");
        }
        if (BYTES_LINE_SEP[0] != 10 && BYTES_LINE_SEP[0] != 13) {
            BYTES_LINE_SEP = new byte[]{10};
        }
    }
}

