/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.server.HsqlSocketRequestHandler;
import org.hsqldb.server.Server;
import org.hsqldb.server.ServerProperties;

public class HsqlServerFactory {
    private HsqlServerFactory() {
    }

    public static HsqlSocketRequestHandler createHsqlServer(String dbFilePath, boolean debugMessages, boolean silentMode) throws SQLException {
        ServerProperties props = new ServerProperties(1);
        props.setProperty("server.dbname.0", "");
        props.setProperty("server.database.0", dbFilePath);
        props.setProperty("server.trace", debugMessages);
        props.setProperty("server.silent", silentMode);
        Server server = new Server();
        try {
            server.setProperties(props);
        }
        catch (Exception e) {
            throw new SQLException("Failed to set server properties: " + e);
        }
        if (!server.openDatabases()) {
            Throwable t = server.getServerError();
            if (t instanceof HsqlException) {
                throw JDBCUtil.sqlException((HsqlException)t);
            }
            throw JDBCUtil.sqlException(Error.error(458));
        }
        server.setState(1);
        return server;
    }
}

