/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.resources.ResourceBundleHandler;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.server.WebServer;

class WebServerConnection
implements Runnable {
    static final String ENCODING = "ISO-8859-1";
    private Charset iso = Charset.forName("ISO-8859-1");
    private CharsetDecoder iso_8859_1_decoder = this.iso.newDecoder();
    private Socket socket;
    private WebServer server;
    private static final int REQUEST_TYPE_BAD = 0;
    private static final int REQUEST_TYPE_GET = 1;
    private static final int REQUEST_TYPE_HEAD = 2;
    private static final int REQUEST_TYPE_POST = 3;
    private static final String HEADER_OK = "HTTP/1.0 200 OK";
    private static final String HEADER_BAD_REQUEST = "HTTP/1.0 400 Bad Request";
    private static final String HEADER_NOT_FOUND = "HTTP/1.0 404 Not Found";
    private static final String HEADER_FORBIDDEN = "HTTP/1.0 403 Forbidden";
    static final int BUFFER_SIZE = 256;
    final byte[] mainBuffer = new byte[256];
    private RowOutputBinary rowOut = new RowOutputBinary(this.mainBuffer);
    private RowInputBinary rowIn = new RowInputBinary(this.rowOut);
    static byte[] BYTES_GET;
    static byte[] BYTES_HEAD;
    static byte[] BYTES_POST;
    static byte[] BYTES_CONTENT;
    static final byte[] BYTES_WHITESPACE;
    private static final int hnd_content_types;

    WebServerConnection(Socket socket, WebServer server) {
        this.server = server;
        this.socket = socket;
    }

    private String getMimeTypeString(String name) {
        if (name == null) {
            return "text/html";
        }
        int pos = name.lastIndexOf(46);
        String key = null;
        String mimeType = null;
        if (pos >= 0) {
            key = name.substring(pos).toLowerCase();
            mimeType = this.server.serverProperties.getProperty(key);
        }
        if (mimeType == null && key.length() > 1) {
            mimeType = ResourceBundleHandler.getString(hnd_content_types, key.substring(1));
        }
        return mimeType == null ? "text/html" : mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DataInputStream inStream = null;
        try {
            int offset;
            int count;
            inStream = new DataInputStream(this.socket.getInputStream());
            String name = null;
            int method = 0;
            do {
                if ((count = InOutUtil.readLine(inStream, this.rowOut)) != 0) continue;
                throw new Exception();
            } while (count < 2);
            byte[] byteArray = this.rowOut.toByteArray();
            if (ArrayUtil.containsAt(byteArray, offset = this.rowOut.size() - count, BYTES_POST)) {
                method = 3;
                offset += BYTES_POST.length;
            } else if (ArrayUtil.containsAt(byteArray, offset, BYTES_GET)) {
                method = 1;
                offset += BYTES_GET.length;
            } else if (ArrayUtil.containsAt(byteArray, offset, BYTES_HEAD)) {
                method = 2;
                offset += BYTES_HEAD.length;
            } else {
                method = 0;
            }
            count = ArrayUtil.countStartElementsAt(byteArray, offset, BYTES_WHITESPACE);
            if (count == 0) {
                method = 0;
            }
            offset += count;
            count = ArrayUtil.countNonStartElementsAt(byteArray, offset, BYTES_WHITESPACE);
            name = new String(byteArray, offset, count, ENCODING);
            switch (method) {
                case 3: {
                    this.processPost(inStream, name);
                    return;
                }
                case 0: {
                    this.processError(0);
                    return;
                }
                case 1: {
                    this.processGet(name, true);
                    return;
                }
                case 2: {
                    this.processGet(name, false);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            this.server.printStackTrace(e);
            return;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                this.socket.close();
            }
            catch (IOException ioe) {
                this.server.printStackTrace(ioe);
            }
        }
    }

    private void processPost(InputStream inStream, String name) throws IOException {
        try {
            int readLineLength;
            while ((readLineLength = InOutUtil.readLine(inStream, this.rowOut)) > 2) {
            }
            String requestHeader = this.iso_8859_1_decoder.decode(ByteBuffer.wrap(this.rowOut.toByteArray())).toString();
            if (requestHeader.indexOf("Content-Type: application/octet-stream") < 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.processError(400);
            return;
        }
        this.processQuery(inStream);
    }

    void processQuery(InputStream inStream) {
        try {
            Result resultOut;
            DataInputStream dataIn = new DataInputStream(inStream);
            int databaseID = dataIn.readInt();
            long sessionID = dataIn.readLong();
            byte mode = dataIn.readByte();
            Session session = DatabaseManager.getSession(databaseID, sessionID);
            Result resultIn = Result.newResult(session, mode, dataIn, this.rowIn);
            resultIn.setDatabaseId(databaseID);
            resultIn.setSessionId(sessionID);
            if (resultIn.getType() == 31) {
                try {
                    String databaseName = resultIn.getDatabaseName();
                    int dbIndex = this.server.getDBIndex(databaseName);
                    int dbID = this.server.dbID[dbIndex];
                    session = DatabaseManager.newSession(dbID, resultIn.getMainString(), resultIn.getSubString(), resultIn.getZoneString(), resultIn.getUpdateCount());
                    resultIn.readAdditionalResults(session, dataIn, this.rowIn);
                    resultOut = Result.newConnectionAcknowledgeResponse(session.getDatabase(), session.getId(), dbID);
                }
                catch (HsqlException e) {
                    resultOut = Result.newErrorResult(e);
                }
                catch (RuntimeException e) {
                    resultOut = Result.newErrorResult(e);
                }
            } else {
                int dbID = resultIn.getDatabaseId();
                if (session == null) {
                    resultOut = Result.newErrorResult(Error.error(402));
                } else {
                    resultIn.setSession(session);
                    resultIn.readLobResults(session, dataIn, this.rowIn);
                    resultOut = session.execute(resultIn);
                }
            }
            int type = resultIn.getType();
            if (type == 32 || type == 10) {
                DataOutputStream dataOut = new DataOutputStream(this.socket.getOutputStream());
                String header = this.getHead(HEADER_OK, false, "application/octet-stream", 6);
                dataOut.write(header.getBytes(ENCODING));
                dataOut.writeByte(32);
                dataOut.writeInt(4);
                dataOut.writeByte(0);
                dataOut.close();
                return;
            }
            HsqlByteArrayOutputStream memStream = new HsqlByteArrayOutputStream();
            DataOutputStream tempOutput = new DataOutputStream(memStream);
            resultOut.write(session, tempOutput, this.rowOut);
            DataOutputStream dataOut = new DataOutputStream(this.socket.getOutputStream());
            String header = this.getHead(HEADER_OK, false, "application/octet-stream", memStream.size());
            dataOut.write(header.getBytes(ENCODING));
            memStream.writeTo(dataOut);
            dataOut.close();
        }
        catch (Exception e) {
            this.server.printStackTrace(e);
        }
    }

    private void processGet(String name, boolean send) {
        try {
            String hdr;
            if (name.endsWith("/")) {
                name = name + this.server.getDefaultWebPage();
            }
            if (name.indexOf("..") != -1) {
                this.processError(403);
                return;
            }
            name = this.server.getWebRoot() + name;
            if (File.separatorChar != '/') {
                name = name.replace('/', File.separatorChar);
            }
            InputStream is = null;
            this.server.printWithThread("GET " + name);
            try {
                File file = new File(name);
                is = new DataInputStream(new FileInputStream(file));
                hdr = this.getHead(HEADER_OK, true, this.getMimeTypeString(name), (int)file.length());
            }
            catch (IOException e) {
                this.processError(404);
                if (is != null) {
                    is.close();
                }
                return;
            }
            BufferedOutputStream os = new BufferedOutputStream(this.socket.getOutputStream());
            ((OutputStream)os).write(hdr.getBytes(ENCODING));
            if (send) {
                int b;
                while ((b = is.read()) != -1) {
                    ((OutputStream)os).write(b);
                }
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            is.close();
        }
        catch (Exception e) {
            this.server.printError("processGet: " + e.toString());
            this.server.printStackTrace(e);
        }
    }

    String getHead(String responseCodeString, boolean addInfo, String mimeType, int length) {
        StringBuffer sb = new StringBuffer(128);
        sb.append(responseCodeString).append("\r\n");
        if (addInfo) {
            sb.append("Allow: GET, HEAD, POST\nMIME-Version: 1.0\r\n");
            sb.append("Server: ").append("HSQL Database Engine").append("\r\n");
        }
        if (mimeType != null) {
            sb.append("Cache-Control: no-cache\r\n");
            sb.append("Content-Type: ").append(mimeType).append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private void processError(int code) {
        String msg;
        this.server.printWithThread("processError " + code);
        switch (code) {
            case 400: {
                msg = this.getHead(HEADER_BAD_REQUEST, false, null, 0);
                msg = msg + ResourceBundleHandler.getString(WebServer.webBundleHandle, "BAD_REQUEST");
                break;
            }
            case 403: {
                msg = this.getHead(HEADER_FORBIDDEN, false, null, 0);
                msg = msg + ResourceBundleHandler.getString(WebServer.webBundleHandle, "FORBIDDEN");
                break;
            }
            default: {
                msg = this.getHead(HEADER_NOT_FOUND, false, null, 0);
                msg = msg + ResourceBundleHandler.getString(WebServer.webBundleHandle, "NOT_FOUND");
            }
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(this.socket.getOutputStream());
            ((OutputStream)os).write(msg.getBytes(ENCODING));
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            this.server.printError("processError: " + e.toString());
            this.server.printStackTrace(e);
        }
    }

    String getConnectionThreadName() {
        return "HSQLDB HTTP Connection @" + Integer.toString(this.hashCode(), 16);
    }

    static {
        try {
            BYTES_GET = "GET".getBytes(ENCODING);
            BYTES_HEAD = "HEAD".getBytes(ENCODING);
            BYTES_POST = "POST".getBytes(ENCODING);
            BYTES_CONTENT = "Content-Length: ".getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw Error.runtimeError(201, "RowOutputTextLog");
        }
        BYTES_WHITESPACE = new byte[]{32, 9};
        hnd_content_types = ResourceBundleHandler.getBundleHandle("webserver-content-types", null);
    }
}

