/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.lar;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.spring.orm.LastSessionRecorderHelperUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@ProviderType
public class StagedModelDataHandlerUtil {
    private static final Log _log = LogFactoryUtil.getLog(StagedModelDataHandlerUtil.class);

    public static void deleteStagedModel(PortletDataContext portletDataContext, Element deletionElement) throws PortalException {
        String className = deletionElement.attributeValue("class-name");
        String extraData = deletionElement.attributeValue("extra-data");
        String uuid = deletionElement.attributeValue("uuid");
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(className);
        if (stagedModelDataHandler != null) {
            stagedModelDataHandler.deleteStagedModel(uuid, portletDataContext.getScopeGroupId(), className, extraData);
        }
    }

    public static <T extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, String referrerPortletId, T stagedModel) throws PortletDataException {
        Portlet referrerPortlet = PortletLocalServiceUtil.getPortletById(referrerPortletId);
        if (!ExportImportHelperUtil.isAlwaysIncludeReference(portletDataContext, stagedModel) || !ExportImportHelperUtil.isReferenceWithinExportScope(portletDataContext, stagedModel)) {
            return portletDataContext.addReferenceElement(referrerPortlet, portletDataContext.getExportDataRootElement(), stagedModel, "dependency", true);
        }
        StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, stagedModel);
        return portletDataContext.addReferenceElement(referrerPortlet, portletDataContext.getExportDataRootElement(), stagedModel, "dependency", false);
    }

    @Deprecated
    public static <T extends StagedModel, U extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, Class<?> referrerStagedModelClass, U stagedModel, Class<?> stagedModelClass, String referenceType) throws PortletDataException {
        return StagedModelDataHandlerUtil.exportReferenceStagedModel(portletDataContext, referrerStagedModel, stagedModel, referenceType);
    }

    @Deprecated
    public static <T extends StagedModel, U extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, Element referrerStagedModelElement, U stagedModel, Class<?> stagedModelClass, String referenceType) throws PortletDataException {
        return StagedModelDataHandlerUtil.exportReferenceStagedModel(portletDataContext, referrerStagedModel, stagedModel, referenceType);
    }

    public static <T extends StagedModel, U extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, U stagedModel, String referenceType) throws PortletDataException {
        Element referrerStagedModelElement = portletDataContext.getExportDataElement(referrerStagedModel);
        if (!ExportImportHelperUtil.isAlwaysIncludeReference(portletDataContext, stagedModel) || !ExportImportHelperUtil.isReferenceWithinExportScope(portletDataContext, stagedModel)) {
            return portletDataContext.addReferenceElement(referrerStagedModel, referrerStagedModelElement, stagedModel, "dependency", true);
        }
        StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, stagedModel);
        return portletDataContext.addReferenceElement(referrerStagedModel, referrerStagedModelElement, stagedModel, referenceType, false);
    }

    public static <T extends StagedModel> void exportStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return;
        }
        stagedModelDataHandler.exportStagedModel(portletDataContext, stagedModel);
    }

    public static <T extends StagedModel> String getDisplayName(T stagedModel) {
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return "";
        }
        return stagedModelDataHandler.getDisplayName(stagedModel);
    }

    public static Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, StagedModel stagedModel) {
        StagedModelDataHandler<StagedModel> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return Collections.emptyMap();
        }
        return stagedModelDataHandler.getReferenceAttributes(portletDataContext, stagedModel);
    }

    public static void importReferenceStagedModel(PortletDataContext portletDataContext, Class<?> stagedModelClass, long classPK) throws PortletDataException {
        StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, stagedModelClass.getName(), classPK);
    }

    public static void importReferenceStagedModel(PortletDataContext portletDataContext, String stagedModelClassName, long classPK) throws PortletDataException {
        Element referenceElement = portletDataContext.getReferenceElement(stagedModelClassName, classPK);
        StagedModelDataHandlerUtil.doImportReferenceStagedModel(portletDataContext, referenceElement, stagedModelClassName);
    }

    public static <T extends StagedModel> void importReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, Class<?> stagedModelClass, long classPK) throws PortletDataException {
        StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, referrerStagedModel, stagedModelClass.getName(), classPK);
    }

    public static <T extends StagedModel> void importReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, String stagedModelClassName, long classPK) throws PortletDataException {
        Element referenceElement = portletDataContext.getReferenceElement(referrerStagedModel, stagedModelClassName, classPK);
        StagedModelDataHandlerUtil.doImportReferenceStagedModel(portletDataContext, referenceElement, stagedModelClassName);
    }

    public static void importReferenceStagedModels(PortletDataContext portletDataContext, Class<?> stagedModelClass) throws PortletDataException {
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        Element referencesElement = importDataRootElement.element("references");
        if (referencesElement == null) {
            return;
        }
        List<Element> referenceElements = referencesElement.elements();
        for (Element referenceElement : referenceElements) {
            String className = referenceElement.attributeValue("class-name");
            String stagedModelClassName = stagedModelClass.getName();
            if (!stagedModelClassName.equals(className)) continue;
            boolean missing = portletDataContext.isMissingReference(referenceElement);
            StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(stagedModelClassName);
            if (stagedModelDataHandler == null) continue;
            if (missing) {
                stagedModelDataHandler.importMissingReference(portletDataContext, referenceElement);
                continue;
            }
            StagedModelDataHandlerUtil.importStagedModel(portletDataContext, referenceElement);
        }
    }

    public static <T extends StagedModel> void importReferenceStagedModels(PortletDataContext portletDataContext, T referrerStagedModel, Class<?> stagedModelClass) throws PortletDataException {
        List<Element> referenceElements = portletDataContext.getReferenceElements(referrerStagedModel, stagedModelClass);
        for (Element referenceElement : referenceElements) {
            long classPK = GetterUtil.getLong(referenceElement.attributeValue("class-pk"));
            StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, referrerStagedModel, stagedModelClass, classPK);
        }
    }

    public static void importStagedModel(PortletDataContext portletDataContext, Element element) throws PortletDataException {
        StagedModel stagedModel = StagedModelDataHandlerUtil._getStagedModel(portletDataContext, element);
        StagedModelDataHandlerUtil.importStagedModel(portletDataContext, stagedModel);
    }

    public static <T extends StagedModel> void importStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return;
        }
        stagedModelDataHandler.importStagedModel(portletDataContext, stagedModel);
        LastSessionRecorderHelperUtil.syncLastSessionState();
    }

    protected static void doImportReferenceStagedModel(PortletDataContext portletDataContext, Element referenceElement, String stagedModelClassName) throws PortletDataException {
        if (referenceElement == null) {
            return;
        }
        boolean missing = portletDataContext.isMissingReference(referenceElement);
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(stagedModelClassName);
        if (stagedModelDataHandler == null) {
            return;
        }
        if (missing) {
            stagedModelDataHandler.importMissingReference(portletDataContext, referenceElement);
            return;
        }
        StagedModelDataHandlerUtil.importStagedModel(portletDataContext, referenceElement);
    }

    private static StagedModel _getReferenceStagedModel(PortletDataContext portletDataContext, Element element) {
        long classPK;
        String className;
        long groupId = GetterUtil.getLong(element.attributeValue("group-id"));
        String path = ExportImportPathUtil.getModelPath(groupId, className = element.attributeValue("class-name"), classPK = GetterUtil.getLong(element.attributeValue("class-pk")));
        StagedModel stagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(element, path);
        if (stagedModel != null) {
            return stagedModel;
        }
        path = ExportImportPathUtil.getCompanyModelPath(portletDataContext.getSourceCompanyId(), className, classPK);
        return (StagedModel)portletDataContext.getZipEntryAsObject(element, path);
    }

    private static StagedModel _getStagedModel(PortletDataContext portletDataContext, Element element) {
        StagedModel stagedModel = null;
        String elementName = element.getName();
        if (elementName.equals("reference")) {
            stagedModel = StagedModelDataHandlerUtil._getReferenceStagedModel(portletDataContext, element);
        } else {
            String path = element.attributeValue("path");
            stagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(element, path);
        }
        return stagedModel;
    }

    private static <T extends StagedModel> StagedModelDataHandler<T> _getStagedModelDataHandler(T stagedModel) {
        if (stagedModel == null) {
            _log.error("Unable to get a staged model data handler for a null value because a model was not exported properly");
            return null;
        }
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(ExportImportClassedModelUtil.getClassName(stagedModel));
        return stagedModelDataHandler;
    }
}

