/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.util.ClassResolverUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ProtectedObjectInputStream
extends ObjectInputStream {
    private static final Set<String> _restrictedClassNames;

    public ProtectedObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    protected Class<?> doResolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        String name = objectStreamClass.getName();
        Thread thread = Thread.currentThread();
        return ClassResolverUtil.resolve(name, thread.getContextClassLoader());
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        if (_restrictedClassNames.contains(objectStreamClass.getName())) {
            throw new InvalidClassException("Reject resolving of restricted class " + objectStreamClass.getName());
        }
        return this.doResolveClass(objectStreamClass);
    }

    static {
        String[] restrictedClassNames = StringUtil.split(System.getProperty(ProtectedObjectInputStream.class.getName() + ".restricted.class.names"));
        _restrictedClassNames = new HashSet<String>(Arrays.asList(restrictedClassNames));
    }
}

