/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process.local;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.local.ExceptionProcessCallable;
import com.liferay.portal.kernel.process.local.ReturnProcessCallable;
import com.liferay.portal.kernel.process.log.ProcessOutputStream;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class LocalProcessLauncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) throws IOException {
        PrintStream oldOutPrintStream = System.out;
        ObjectOutputStream objectOutputStream = null;
        ProcessOutputStream outProcessOutputStream = null;
        PrintStream printStream = oldOutPrintStream;
        synchronized (printStream) {
            oldOutPrintStream.flush();
            FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
            objectOutputStream = new ObjectOutputStream(new UnsyncBufferedOutputStream(fileOutputStream));
            outProcessOutputStream = new ProcessOutputStream(objectOutputStream, false);
            ProcessContext._setProcessOutputStream(outProcessOutputStream);
            PrintStream newOutPrintStream = new PrintStream(outProcessOutputStream, true);
            System.setOut(newOutPrintStream);
        }
        ProcessOutputStream errProcessOutputStream = new ProcessOutputStream(objectOutputStream, true);
        PrintStream errPrintStream = new PrintStream(errProcessOutputStream, true);
        System.setErr(errPrintStream);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            ObjectInputStream bootstrapObjectInputStream = new ObjectInputStream(System.in);
            String processCallableName = (String)bootstrapObjectInputStream.readObject();
            String logPrefixString = "[".concat(processCallableName).concat("]");
            byte[] logPrefix = logPrefixString.getBytes("UTF-8");
            outProcessOutputStream.setLogPrefix(logPrefix);
            errProcessOutputStream.setLogPrefix(logPrefix);
            String classPath = (String)bootstrapObjectInputStream.readObject();
            URLClassLoader classLoader = new URLClassLoader(LocalProcessLauncher._getClassPathURLs(classPath));
            currentThread.setContextClassLoader(classLoader);
            ClassLoaderObjectInputStream objectInputStream = new ClassLoaderObjectInputStream(bootstrapObjectInputStream, classLoader);
            ProcessCallable processCallable = (ProcessCallable)objectInputStream.readObject();
            Thread thread = new Thread((Runnable)new ProcessCallableRunner(objectInputStream), "ProcessCallable-Runner");
            thread.setDaemon(true);
            thread.start();
            Object result = processCallable.call();
            System.out.flush();
            outProcessOutputStream.writeProcessCallable(new ReturnProcessCallable(result));
            outProcessOutputStream.flush();
        }
        catch (Throwable t) {
            errPrintStream.flush();
            ProcessException processException = null;
            processException = t instanceof ProcessException ? (ProcessException)t : new ProcessException(t);
            errProcessOutputStream.writeProcessCallable(new ExceptionProcessCallable(processException));
            errProcessOutputStream.flush();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    private static URL[] _getClassPathURLs(String classPath) throws MalformedURLException {
        String[] paths;
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (String path : paths = StringUtil.split(classPath, File.pathSeparatorChar)) {
            File file = new File(path);
            URI uri = file.toURI();
            urls.add(uri.toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static class ProcessCallableRunner
    implements Runnable {
        private final ObjectInputStream _objectInputStream;

        public ProcessCallableRunner(ObjectInputStream objectInputStream) {
            this._objectInputStream = objectInputStream;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ProcessCallable processCallable = (ProcessCallable)this._objectInputStream.readObject();
                        processCallable.call();
                    }
                }
                catch (Exception e) {
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    UnsyncPrintWriter unsyncPrintWriter = new UnsyncPrintWriter(unsyncByteArrayOutputStream);
                    unsyncPrintWriter.println(e);
                    e.printStackTrace(unsyncPrintWriter);
                    unsyncPrintWriter.println();
                    unsyncPrintWriter.flush();
                    System.err.write(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
                    System.err.flush();
                    continue;
                }
                break;
            }
        }
    }

    private static class PingbackProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final String _message;

        public PingbackProcessCallable(String message) {
            this._message = message;
        }

        @Override
        public String call() {
            return this._message;
        }
    }

    private static class HeartbeatThread
    extends Thread {
        private volatile boolean _detach;
        private final long _interval;
        private final ProcessCallable<String> _pringBackProcessCallable;
        private final ShutdownHook _shutdownHook;

        public HeartbeatThread(String message, long interval, ShutdownHook shutdownHook) {
            if (shutdownHook == null) {
                throw new IllegalArgumentException("Shutdown hook is null");
            }
            this._interval = interval;
            this._shutdownHook = shutdownHook;
            this._pringBackProcessCallable = new PingbackProcessCallable(message);
            this.setDaemon(true);
            this.setName(HeartbeatThread.class.getSimpleName());
        }

        public void detach() {
            this._detach = true;
            this.interrupt();
        }

        @Override
        public void run() {
            ProcessOutputStream processOutputStream = ProcessContext.getProcessOutputStream();
            int shutdownCode = 0;
            Throwable shutdownThrowable = null;
            while (!this._detach) {
                try {
                    HeartbeatThread.sleep(this._interval);
                    processOutputStream.writeProcessCallable(this._pringBackProcessCallable);
                }
                catch (InterruptedException ie) {
                    if (this._detach) {
                        return;
                    }
                    shutdownThrowable = ie;
                    shutdownCode = 2;
                }
                catch (IOException ioe) {
                    shutdownThrowable = ioe;
                    shutdownCode = 1;
                }
                catch (Throwable throwable) {
                    shutdownThrowable = throwable;
                    shutdownCode = 3;
                }
                if (shutdownCode == 0) continue;
                this._detach = this._shutdownHook.shutdown(shutdownCode, shutdownThrowable);
            }
        }
    }

    public static interface ShutdownHook {
        public static final int BROKEN_PIPE_CODE = 1;
        public static final int INTERRUPTION_CODE = 2;
        public static final int UNKNOWN_CODE = 3;

        public boolean shutdown(int var1, Throwable var2);
    }

    public static class ProcessContext {
        private static final ConcurrentMap<String, Object> _attributes = new ConcurrentHashMap<String, Object>();
        private static final AtomicReference<HeartbeatThread> _heartbeatThreadReference = new AtomicReference();
        private static ProcessOutputStream _processOutputStream;

        public static boolean attach(String message, long interval, ShutdownHook shutdownHook) {
            HeartbeatThread heartbeatThread = new HeartbeatThread(message, interval, shutdownHook);
            boolean value = _heartbeatThreadReference.compareAndSet(null, heartbeatThread);
            if (value) {
                heartbeatThread.start();
            }
            return value;
        }

        public static void detach() throws InterruptedException {
            HeartbeatThread heartbeatThread = _heartbeatThreadReference.getAndSet(null);
            if (heartbeatThread != null) {
                heartbeatThread.detach();
                heartbeatThread.join();
            }
        }

        public static ConcurrentMap<String, Object> getAttributes() {
            return _attributes;
        }

        public static ProcessOutputStream getProcessOutputStream() {
            return _processOutputStream;
        }

        public static boolean isAttached() {
            HeartbeatThread attachThread = _heartbeatThreadReference.get();
            return attachThread != null;
        }

        private static void _setProcessOutputStream(ProcessOutputStream processOutputStream) {
            _processOutputStream = processOutputStream;
        }

        private ProcessContext() {
        }
    }
}

