/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Date;

public class SchedulerEventMessageListenerWrapper
implements SchedulerEventMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(SchedulerEventMessageListenerWrapper.class);
    @Deprecated
    private String _groupName;
    @Deprecated
    private String _jobName;
    private MessageListener _messageListener;
    private volatile SchedulerEntry _schedulerEntry;

    @Override
    public SchedulerEntry getSchedulerEntry() {
        return this._schedulerEntry;
    }

    @Override
    public void receive(Message message) throws MessageListenerException {
        Trigger trigger;
        String destinationName = GetterUtil.getString(message.getString("DESTINATION_NAME"));
        String jobName = message.getString("JOB_NAME");
        String groupName = message.getString("GROUP_NAME");
        if (!(!destinationName.equals("liferay/scheduler_dispatch") || jobName.equals((trigger = this._schedulerEntry.getTrigger()).getJobName()) && groupName.equals(trigger.getGroupName()))) {
            return;
        }
        try {
            this._messageListener.receive(message);
        }
        catch (Exception e) {
            this.handleException(message, e);
            if (e instanceof MessageListenerException) {
                throw (MessageListenerException)e;
            }
            throw new MessageListenerException(e);
        }
        finally {
            block20: {
                TriggerState triggerState = null;
                if (message.getBoolean("DISABLE")) {
                    triggerState = TriggerState.COMPLETE;
                    if (destinationName.equals("liferay/scheduler_dispatch")) {
                        MessageBusUtil.unregisterMessageListener(destinationName, this);
                    }
                    StorageType storageType = (StorageType)((Object)message.get("STORAGE_TYPE"));
                    try {
                        SchedulerEngineHelperUtil.delete(jobName, groupName, storageType);
                    }
                    catch (SchedulerException se) {
                        if (_log.isInfoEnabled()) {
                            _log.info("Unable to delete job " + jobName + " in group " + groupName, se);
                        }
                    }
                } else {
                    triggerState = TriggerState.NORMAL;
                }
                try {
                    SchedulerEngineHelperUtil.auditSchedulerJobs(message, triggerState);
                }
                catch (Exception e) {
                    if (!_log.isInfoEnabled()) break block20;
                    _log.info("Unable to send audit message", e);
                }
            }
        }
    }

    @Deprecated
    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    @Deprecated
    public void setJobName(String jobName) {
        this._jobName = jobName;
    }

    public void setMessageListener(MessageListener messageListener) {
        this._messageListener = messageListener;
    }

    public void setSchedulerEntry(SchedulerEntry schedulerEntry) {
        this._schedulerEntry = schedulerEntry;
    }

    protected void handleException(Message message, Exception exception) {
        JobState jobState = (JobState)message.get("JOB_STATE");
        if (jobState != null) {
            jobState.addException(exception, new Date());
        }
    }
}

