/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.filter;

import com.liferay.portal.kernel.search.filter.BaseFilter;
import com.liferay.portal.kernel.search.filter.FilterVisitor;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TermsFilter
extends BaseFilter {
    private final String _field;
    private final Set<String> _values = new HashSet<String>();

    public TermsFilter(String field) {
        this._field = field;
    }

    @Override
    public <T> T accept(FilterVisitor<T> filterVisitor) {
        return filterVisitor.visit(this);
    }

    public void addValue(String value) {
        this._values.add(value);
    }

    public void addValues(String ... values) {
        Collections.addAll(this._values, values);
    }

    public String getField() {
        return this._field;
    }

    @Override
    public int getSortOrder() {
        return 4;
    }

    public String[] getValues() {
        return this._values.toArray(new String[this._values.size()]);
    }

    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(7);
        sb.append("{(");
        sb.append(this._field);
        sb.append("=");
        sb.append(this._values);
        sb.append("), ");
        sb.append(super.toString());
        sb.append("}");
        return sb.toString();
    }
}

