/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalClassLoaderServlet
extends HttpServlet
implements PortalLifecycle {
    private static final Log _log = LogFactoryUtil.getLog(PortalClassLoaderServlet.class);
    private volatile boolean _calledPortalDestroy;
    private volatile HttpServlet _servlet;
    private ServletConfig _servletConfig;

    public void destroy() {
        this.portalDestroy();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._servletConfig = servletConfig;
        PortalLifecycleUtil.register(this);
    }

    @Override
    public void portalDestroy() {
        if (!this._calledPortalDestroy) {
            PortalLifecycleUtil.removeDestroy(this);
            this.doPortalDestroy();
            this._calledPortalDestroy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void portalInit() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        try {
            currentThread.setContextClassLoader(portalClassLoader);
            String servletClass = this._servletConfig.getInitParameter("servlet-class");
            this._servlet = (HttpServlet)InstanceFactory.newInstance(portalClassLoader, servletClass);
            this._servlet.init(this._servletConfig);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            this._servlet.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected void doPortalDestroy() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            if (this._servlet != null) {
                this._servlet.destroy();
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }
}

