/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class FutureConverter<T, V>
implements Future<T> {
    private final Future<V> _future;

    public FutureConverter(Future<V> future) {
        this._future = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this._future.cancel(mayInterruptIfRunning);
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        V v = this._future.get();
        try {
            return this.convert(v);
        }
        catch (Throwable throwable) {
            throw new ExecutionException(throwable);
        }
    }

    @Override
    public T get(long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        V v = this._future.get(timeout, timeUnit);
        try {
            return this.convert(v);
        }
        catch (Throwable throwable) {
            throw new ExecutionException(throwable);
        }
    }

    @Override
    public boolean isCancelled() {
        return this._future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this._future.isDone();
    }

    protected abstract T convert(V var1) throws Throwable;
}

