/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.concurrent;

import com.liferay.petra.concurrent.DefaultNoticeableFuture;
import com.liferay.petra.concurrent.FutureConverter;
import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class NoticeableFutureConverter<T, V>
extends FutureConverter<T, V>
implements NoticeableFuture<T> {
    private final DefaultNoticeableFuture<T> _defaultNoticeableFuture = new DefaultNoticeableFuture();

    public NoticeableFutureConverter(NoticeableFuture<V> noticeableFuture) {
        super(noticeableFuture);
        noticeableFuture.addFutureListener(new FutureListener<V>(){

            @Override
            public void complete(Future<V> future) {
                if (future.isCancelled()) {
                    NoticeableFutureConverter.this._defaultNoticeableFuture.cancel(true);
                    return;
                }
                try {
                    NoticeableFutureConverter.this._defaultNoticeableFuture.set(NoticeableFutureConverter.this.convert(future.get()));
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ExecutionException) {
                        throwable = throwable.getCause();
                    }
                    NoticeableFutureConverter.this._defaultNoticeableFuture.setException(throwable);
                }
            }
        });
    }

    @Override
    public boolean addFutureListener(FutureListener<T> futureListener) {
        return this._defaultNoticeableFuture.addFutureListener(futureListener);
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        return (T)this._defaultNoticeableFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        return (T)this._defaultNoticeableFuture.get(timeout, timeUnit);
    }

    @Override
    public boolean removeFutureListener(FutureListener<T> futureListener) {
        return this._defaultNoticeableFuture.removeFutureListener(futureListener);
    }
}

