/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.spi.expression;

import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.expression.DefaultExpression;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import java.util.Objects;
import java.util.function.Consumer;

public class DefaultPredicate
extends BaseASTNode
implements DefaultExpression<Boolean>,
Predicate {
    private final Expression<?> _leftExpression;
    private final Operand _operand;
    private final Expression<?> _rightExpression;
    private final boolean _wrapParentheses;

    public DefaultPredicate(Expression<?> leftExpression, Operand operand, Expression<?> rightExpression) {
        this(leftExpression, operand, rightExpression, false);
    }

    public Predicate and(Expression<Boolean> expression) {
        if (expression == null) {
            return this;
        }
        return new DefaultPredicate(this, Operand.AND, expression);
    }

    public Expression<?> getLeftExpression() {
        return this._leftExpression;
    }

    public Operand getOperand() {
        return this._operand;
    }

    public Expression<?> getRightExpression() {
        return this._rightExpression;
    }

    public boolean isWrapParentheses() {
        return this._wrapParentheses;
    }

    public Predicate or(Expression<Boolean> expression) {
        if (expression == null) {
            return this;
        }
        return new DefaultPredicate(this, Operand.OR, expression);
    }

    public Predicate withParentheses() {
        if (this._wrapParentheses) {
            return this;
        }
        return new DefaultPredicate(this._leftExpression, this._operand, this._rightExpression, true);
    }

    @Override
    protected void doToSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
        if (this._wrapParentheses) {
            consumer.accept("(");
        }
        this._leftExpression.toSQL(consumer, astNodeListener);
        consumer.accept(this._operand.getStringWithSpaces());
        this._rightExpression.toSQL(consumer, astNodeListener);
        if (this._wrapParentheses) {
            consumer.accept(")");
        }
    }

    private DefaultPredicate(Expression<?> leftExpression, Operand operand, Expression<?> rightExpression, boolean wrapParentheses) {
        this._leftExpression = Objects.requireNonNull(leftExpression);
        this._operand = Objects.requireNonNull(operand);
        this._rightExpression = Objects.requireNonNull(rightExpression);
        this._wrapParentheses = wrapParentheses;
    }
}

