/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.RowType;

public class ExpressionAggregate
extends Expression {
    boolean isDistinctAggregate;
    ArrayType arrayType;

    ExpressionAggregate(int type, boolean distinct, Expression e) {
        super(type);
        this.nodes = new Expression[2];
        this.isDistinctAggregate = distinct;
        this.nodes[0] = e;
        this.nodes[1] = Expression.EXPR_TRUE;
    }

    @Override
    boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 71: {
                sb.append(' ').append("COUNT").append('(');
                break;
            }
            case 72: {
                sb.append(' ').append("SUM").append('(');
                sb.append(left).append(')');
                break;
            }
            case 73: {
                sb.append(' ').append("MIN").append('(');
                sb.append(left).append(')');
                break;
            }
            case 74: {
                sb.append(' ').append("MAX").append('(');
                sb.append(left).append(')');
                break;
            }
            case 75: {
                sb.append(' ').append("AVG").append('(');
                sb.append(left).append(')');
                break;
            }
            case 76: {
                sb.append(' ').append("EVERY").append('(');
                sb.append(left).append(')');
                break;
            }
            case 77: {
                sb.append(' ').append("SOME").append('(');
                sb.append(left).append(')');
                break;
            }
            case 78: {
                sb.append(' ').append("STDDEV_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 79: {
                sb.append(' ').append("STDDEV_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 80: {
                sb.append(' ').append("VAR_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 81: {
                sb.append(' ').append("VAR_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 71: {
                sb.append("COUNT").append(' ');
                break;
            }
            case 72: {
                sb.append("SUM").append(' ');
                break;
            }
            case 73: {
                sb.append("MIN").append(' ');
                break;
            }
            case 74: {
                sb.append("MAX").append(' ');
                break;
            }
            case 75: {
                sb.append("AVG").append(' ');
                break;
            }
            case 76: {
                sb.append("EVERY").append(' ');
                break;
            }
            case 77: {
                sb.append("SOME").append(' ');
                break;
            }
            case 78: {
                sb.append("STDDEV_POP").append(' ');
                break;
            }
            case 79: {
                sb.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 80: {
                sb.append("VAR_POP").append(' ');
                break;
            }
            case 81: {
                sb.append("VAR_SAMP").append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, HsqlList unresolvedSet, boolean acceptsSequences) {
        HsqlList conditionSet = this.nodes[1].resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (unresolvedSet == null) {
            unresolvedSet = new ArrayListIdentity();
        }
        unresolvedSet.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroups;
            this.rangeGroup = rangeGroup;
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].getDegree() > 1) {
            this.nodes[0].dataType = new RowType(this.nodes[0].nodeDataTypes);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate) {
            if (this.nodes[0].dataType.isLobType()) {
                throw Error.error(5534);
            }
            if (this.nodes[0].dataType.isCharacterType()) {
                this.arrayType = new ArrayType(this.nodes[0].dataType, Integer.MAX_VALUE);
            }
        }
        this.dataType = SetFunction.getType(session, this.opType, this.nodes[0].dataType);
        this.nodes[1].resolveTypes(session, null);
    }

    @Override
    public boolean equals(Expression other) {
        if (other instanceof ExpressionAggregate) {
            ExpressionAggregate o = (ExpressionAggregate)other;
            if (this.isDistinctAggregate == o.isDistinctAggregate) {
                return super.equals(other);
            }
        }
        return false;
    }

    @Override
    public Object updateAggregatingValue(Session session, Object currValue) {
        if (!this.nodes[1].testCondition(session)) {
            return currValue;
        }
        if (currValue == null) {
            currValue = new SetFunction(session, this.opType, this.nodes[0].dataType, this.dataType, this.isDistinctAggregate, this.arrayType);
        }
        Integer newValue = this.nodes[0].opType == 11 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        ((SetFunction)currValue).add(session, newValue);
        return currValue;
    }

    @Override
    public Object getAggregatedValue(Session session, Object currValue) {
        if (currValue == null) {
            return this.opType == 71 ? Long.valueOf(0L) : null;
        }
        return ((SetFunction)currValue).getValue(session);
    }

    @Override
    public Expression getCondition() {
        return this.nodes[1];
    }

    @Override
    public boolean hasCondition() {
        return !this.nodes[1].isTrue();
    }

    @Override
    public void setCondition(Expression e) {
        this.nodes[1] = e;
    }
}

