/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rights.Grantee;

public abstract class StatementDMQL
extends Statement {
    public static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";
    Table targetTable;
    Table baseTable;
    int[] baseColumnMap;
    RangeVariable[] targetRangeVariables = RangeVariable.emptyArray;
    Table sourceTable;
    Expression condition;
    boolean restartIdentity;
    int[] insertColumnMap = ValuePool.emptyIntArray;
    int[] updateColumnMap = ValuePool.emptyIntArray;
    int[] baseUpdateColumnMap = ValuePool.emptyIntArray;
    Expression[] updateExpressions = Expression.emptyArray;
    Expression[][] multiColumnValues;
    Expression insertExpression;
    boolean[] insertCheckColumns;
    boolean[] updateCheckColumns;
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    QueryExpression queryExpression;
    HsqlNameManager.SimpleName cursorName;
    ExpressionColumn[] parameters;
    ResultMetaData parameterMetaData;
    TableDerived[] subqueries = TableDerived.emptyArray;
    int rangeIteratorCount;
    NumberSequence[] sequences;
    Routine[] routines;
    RangeVariable[] rangeVariables;

    StatementDMQL(int type, int group, HsqlNameManager.HsqlName schemaName) {
        super(type, group);
        this.schemaName = schemaName;
        this.isTransactionStatement = true;
    }

    void setBaseIndexColumnMap() {
        if (this.targetTable != this.baseTable) {
            this.baseColumnMap = this.targetTable.getBaseTableColumnMap();
        }
    }

    public void setCursorName(HsqlNameManager.SimpleName name) {
        this.cursorName = name;
    }

    public HsqlNameManager.SimpleName getCursorName() {
        return this.cursorName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Session session) {
        Result result;
        if (this.targetTable != null && session.isReadOnly() && !this.targetTable.isTemp()) {
            HsqlException e = Error.error(3706);
            return Result.newErrorResult(e);
        }
        if (this.isExplain) {
            return this.getExplainResult(session);
        }
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
            result.getException().setStatementType(this.group, this.type);
        }
        finally {
            this.clearStructures(session);
        }
        return result;
    }

    private Result getExplainResult(Session session) {
        HsqlNameManager.HsqlName name;
        int i;
        Result result = Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        OrderedHashSet set = this.getReferences();
        result.navigator.add(new Object[]{"Object References"});
        for (i = 0; i < set.size(); ++i) {
            name = (HsqlNameManager.HsqlName)set.get(i);
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"Read Locks"});
        for (i = 0; i < this.readTableNames.length; ++i) {
            name = this.readTableNames[i];
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"WriteLocks"});
        for (i = 0; i < this.writeTableNames.length; ++i) {
            name = this.writeTableNames[i];
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        return result;
    }

    abstract Result getResult(Session var1);

    abstract void collectTableNamesForRead(OrderedHashSet var1);

    abstract void collectTableNamesForWrite(OrderedHashSet var1);

    boolean[] getInsertOrUpdateColumnCheckList() {
        switch (this.type) {
            case 50: {
                return this.insertCheckColumns;
            }
            case 82: {
                return this.updateCheckColumns;
            }
            case 128: {
                boolean[] check = (boolean[])ArrayUtil.duplicateArray(this.insertCheckColumns);
                ArrayUtil.orBooleanArray(this.updateCheckColumns, check);
                return check;
            }
        }
        return null;
    }

    void materializeSubQueries(Session session) {
        HashSet subqueryPopFlags = new HashSet();
        for (int i = 0; i < this.subqueries.length; ++i) {
            TableDerived td = this.subqueries[i];
            if (!subqueryPopFlags.add(td) || td.isCorrelated()) continue;
            td.materialise(session);
        }
    }

    TableDerived[] getSubqueries(Session session) {
        int i;
        OrderedHashSet subQueries = null;
        for (i = 0; i < this.targetRangeVariables.length; ++i) {
            if (this.targetRangeVariables[i] == null) continue;
            OrderedHashSet set = this.targetRangeVariables[i].getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        for (i = 0; i < this.updateExpressions.length; ++i) {
            subQueries = this.updateExpressions[i].collectAllSubqueries(subQueries);
        }
        if (this.insertExpression != null) {
            subQueries = this.insertExpression.collectAllSubqueries(subQueries);
        }
        if (this.condition != null) {
            subQueries = this.condition.collectAllSubqueries(subQueries);
        }
        if (this.queryExpression != null) {
            OrderedHashSet set = this.queryExpression.getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        if (this.updatableTableCheck != null) {
            OrderedHashSet set = this.updatableTableCheck.getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return TableDerived.emptyArray;
        }
        Object[] subQueryArray = new TableDerived[subQueries.size()];
        subQueries.toArray(subQueryArray);
        return subQueryArray;
    }

    void setDatabseObjects(Session session, ParserDQL.CompileContext compileContext) {
        this.parameters = compileContext.getParameters();
        this.setParameterMetaData();
        this.subqueries = this.getSubqueries(session);
        this.rangeIteratorCount = compileContext.getRangeVarCount();
        this.rangeVariables = compileContext.getAllRangeVariables();
        this.sequences = compileContext.getSequences();
        this.routines = compileContext.getRoutines();
        OrderedHashSet set = new OrderedHashSet();
        this.collectTableNamesForWrite(set);
        if (set.size() > 0) {
            this.writeTableNames = new HsqlNameManager.HsqlName[set.size()];
            set.toArray(this.writeTableNames);
            set.clear();
        }
        this.collectTableNamesForRead(set);
        set.removeAll(this.writeTableNames);
        if (set.size() > 0) {
            this.readTableNames = new HsqlNameManager.HsqlName[set.size()];
            set.toArray(this.readTableNames);
        }
        if (this.readTableNames.length == 0 && this.writeTableNames.length == 0 && (this.type == 85 || this.type == 65)) {
            this.isTransactionStatement = false;
        }
        this.references = compileContext.getSchemaObjectNames();
        if (this.targetTable != null) {
            this.references.add(this.targetTable.getName());
            if (this.targetTable == this.baseTable) {
                if (this.insertCheckColumns != null) {
                    this.targetTable.getColumnNames(this.insertCheckColumns, this.references);
                }
                if (this.updateCheckColumns != null) {
                    this.targetTable.getColumnNames(this.updateCheckColumns, this.references);
                }
            }
        }
    }

    void checkAccessRights(Session session) {
        int i;
        if (this.targetTable != null && !this.targetTable.isTemp()) {
            Grantee owner;
            if (!session.isProcessingScript()) {
                this.targetTable.checkDataReadOnly();
            }
            if ((owner = this.targetTable.getOwner()) != null && owner.isSystem() && !session.getUser().isSystem()) {
                throw Error.error(5501, this.targetTable.getName().name);
            }
            session.checkReadWrite();
        }
        if (session.isAdmin()) {
            return;
        }
        for (i = 0; i < this.sequences.length; ++i) {
            session.getGrantee().checkAccess(this.sequences[i]);
        }
        for (i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].isLibraryRoutine()) continue;
            session.getGrantee().checkAccess(this.routines[i]);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            if (range.rangeTable.getSchemaName() == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session.getGrantee().checkSelect(range.rangeTable, range.usedColumns);
        }
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }

    Result getWriteAccessResult(Session session) {
        try {
            if (this.targetTable != null && !this.targetTable.isTemp()) {
                session.checkReadWrite();
            }
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        return null;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 19: 
            case 50: 
            case 82: 
            case 128: {
                return ResultMetaData.emptyResultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementDMQL");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    void setParameterMetaData() {
        int offset = 0;
        if (this.parameters.length == 0) {
            this.parameterMetaData = ResultMetaData.emptyParamMetaData;
            return;
        }
        this.parameterMetaData = ResultMetaData.newParameterMetaData(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            int idx = i + offset;
            this.parameterMetaData.columnLabels[idx] = PCOL_PREFIX + (i + 1);
            this.parameterMetaData.columnTypes[idx] = this.parameters[i].dataType;
            if (this.parameters[i].dataType == null) {
                throw Error.error(5567);
            }
            byte parameterMode = 1;
            if (this.parameters[i].column != null && this.parameters[i].column.getParameterMode() != 0) {
                parameterMode = this.parameters[i].column.getParameterMode();
            }
            this.parameterMetaData.paramModes[idx] = parameterMode;
            this.parameterMetaData.paramNullable[idx] = this.parameters[i].column == null ? (byte)1 : this.parameters[i].column.getNullability();
        }
    }

    @Override
    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    String describeImpl(Session session) throws Exception {
        StringBuffer sb = new StringBuffer();
        int blanks = 0;
        switch (this.type) {
            case 85: {
                sb.append(this.queryExpression.describe(session, 0));
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2);
                return sb.toString();
            }
            case 50: {
                if (this.queryExpression == null) {
                    sb.append("INSERT VALUES");
                    sb.append('[').append('\n');
                    this.appendMultiColumns(sb, this.insertColumnMap).append('\n');
                    this.appendTable(sb).append('\n');
                    this.appendParms(sb).append('\n');
                    this.appendSubqueries(session, sb, 2).append(']');
                    return sb.toString();
                }
                sb.append("INSERT SELECT");
                sb.append('[').append('\n');
                this.appendColumns(sb, this.insertColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                sb.append(this.queryExpression.describe(session, blanks)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 82: {
                sb.append("UPDATE");
                sb.append('[').append('\n');
                this.appendColumns(sb, this.updateColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 19: {
                sb.append("DELETE");
                sb.append('[').append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 7: {
                sb.append("CALL");
                sb.append('[').append(']');
                return sb.toString();
            }
            case 128: {
                sb.append("MERGE");
                sb.append('[').append('\n');
                this.appendMultiColumns(sb, this.insertColumnMap).append('\n');
                this.appendColumns(sb, this.updateColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(Session session, StringBuffer sb, int blanks) {
        sb.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            sb.append("\n[level=").append(this.subqueries[i].depth).append('\n');
            if (this.subqueries[i].queryExpression == null) {
                for (int j = 0; j < blanks; ++j) {
                    sb.append(' ');
                }
                sb.append("value expression");
            } else {
                sb.append(this.subqueries[i].queryExpression.describe(session, blanks));
            }
            sb.append("]");
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendTable(StringBuffer sb) {
        sb.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return sb;
    }

    private StringBuffer appendSourceTable(StringBuffer sb) {
        sb.append("SOURCE TABLE[").append(this.sourceTable.getName().name).append(']');
        return sb;
    }

    private StringBuffer appendColumns(StringBuffer sb, int[] columnMap) {
        int i;
        if (columnMap == null || this.updateExpressions.length == 0) {
            return sb;
        }
        sb.append("COLUMNS=[");
        for (i = 0; i < columnMap.length; ++i) {
            sb.append('\n').append(columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn(columnMap[i]).getNameString());
        }
        for (i = 0; i < this.updateExpressions.length; ++i) {
            sb.append('[').append(this.updateExpressions[i]).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendMultiColumns(StringBuffer sb, int[] columnMap) {
        if (columnMap == null || this.multiColumnValues == null) {
            return sb;
        }
        sb.append("COLUMNS=[");
        for (int j = 0; j < this.multiColumnValues.length; ++j) {
            for (int i = 0; i < columnMap.length; ++i) {
                sb.append('\n').append(columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn((int)columnMap[i]).getName().name).append('[').append(this.multiColumnValues[j][i]).append(']');
            }
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendParms(StringBuffer sb) {
        sb.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            sb.append('\n').append('@').append(i).append('[').append(this.parameters[i].describe(null, 0)).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendCondition(Session session, StringBuffer sb) {
        return this.condition == null ? sb.append("CONDITION[]\n") : sb.append("CONDITION[").append(this.condition.describe(session, 0)).append("]\n");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    public final boolean isCatalogLock() {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }

    @Override
    public void clearStructures(Session session) {
        session.sessionContext.clearStructures(this);
    }
}

