/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.Session;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.result.Result;

public class StatementSchemaDefinition
extends StatementSchema {
    StatementSchema[] statements;

    StatementSchemaDefinition(StatementSchema[] statements) {
        super(64, 2001);
        this.statements = statements;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        Table table;
        int i;
        HsqlNameManager.HsqlName schemaDefinitionName = this.statements[0].getSchemaName();
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        Result result = this.statements[0].execute(session);
        HsqlArrayList constraints = new HsqlArrayList();
        StatementSchema log = new StatementSchema(null, 1161);
        if (this.statements.length == 1 || result.isError()) {
            return result;
        }
        HsqlNameManager.HsqlName oldSessionSchema = session.getCurrentSchemaHsqlName();
        for (i = 1; i < this.statements.length; ++i) {
            try {
                session.setSchema(schemaDefinitionName.name);
            }
            catch (HsqlException e) {
                // empty catch block
            }
            this.statements[i].setSchemaHsqlName(schemaDefinitionName);
            session.parser.reset(this.statements[i].getSQL());
            try {
                session.parser.read();
                switch (this.statements[i].getType()) {
                    case 48: 
                    case 49: {
                        result = this.statements[i].execute(session);
                        break;
                    }
                    case 77: {
                        StatementSchema cs = session.parser.compileCreate();
                        cs.isSchemaDefinition = true;
                        cs.setSchemaHsqlName(schemaDefinitionName);
                        if (session.parser.token.tokenType != 872) {
                            throw session.parser.unexpectedToken();
                        }
                        cs.isLogged = false;
                        result = cs.execute(session);
                        HsqlNameManager.HsqlName name = ((Table)cs.arguments[0]).getName();
                        table = (Table)session.database.schemaManager.getSchemaObject(name);
                        constraints.addAll((HsqlArrayList)cs.arguments[1]);
                        ((HsqlArrayList)cs.arguments[1]).clear();
                        log.sql = table.getSQL();
                        log.execute(session);
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 61: 
                    case 83: 
                    case 133: {
                        result = this.statements[i].execute(session);
                        break;
                    }
                    case 14: 
                    case 23: 
                    case 80: 
                    case 84: 
                    case 1125: {
                        StatementSchema cs = session.parser.compileCreate();
                        cs.isSchemaDefinition = true;
                        cs.setSchemaHsqlName(schemaDefinitionName);
                        if (session.parser.token.tokenType != 872) {
                            throw session.parser.unexpectedToken();
                        }
                        result = cs.execute(session);
                        break;
                    }
                    case 6: 
                    case 52: 
                    case 79: 
                    case 114: 
                    case 117: {
                        throw session.parser.unsupportedFeature();
                    }
                    default: {
                        throw Error.runtimeError(201, "");
                    }
                }
                if (!result.isError()) continue;
            }
            catch (HsqlException e) {
                result = Result.newErrorResult(e, this.statements[i].getSQL());
            }
            break;
        }
        if (!result.isError()) {
            try {
                for (i = 0; i < constraints.size(); ++i) {
                    Constraint c = (Constraint)constraints.get(i);
                    table = session.database.schemaManager.getUserTable(session, c.core.refTableName);
                    ParserDDL.addForeignKey(session, table, c, null);
                    log.sql = c.getSQL();
                    log.execute(session);
                }
            }
            catch (HsqlException e) {
                result = Result.newErrorResult(e, this.sql);
            }
        }
        if (result.isError()) {
            try {
                session.database.schemaManager.dropSchema(session, schemaDefinitionName.name, true);
                session.database.logger.writeOtherStatement(session, this.getDropSchemaStatement(schemaDefinitionName));
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
        session.setCurrentSchemaHsqlName(oldSessionSchema);
        return result;
    }

    String getDropSchemaStatement(HsqlNameManager.HsqlName schema) {
        return "DROP SCHEMA " + schema.statementName + " " + "CASCADE";
    }

    @Override
    public boolean isAutoCommitStatement() {
        return true;
    }
}

