/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMV2PL
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();

    public TransactionManagerMV2PL(Database db) {
        this.database = db;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new LongKeyHashMap(10000);
        this.txModel = 1;
        this.catalogNameList = new HsqlNameManager.HsqlName[]{this.database.getCatalogName()};
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 1;
    }

    @Override
    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        this.writeLock.lock();
        try {
            int limit = session.rowActionList.size();
            session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                action.prepareCommit(session);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object[] list;
            int limit = session.rowActionList.size();
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.endTransaction(session);
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                action.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            int newLimit = session.rowActionList.size();
            if (newLimit > limit) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(list, limit, newLimit, session.actionTimestamp);
                this.finaliseRows(session, list, limit, newLimit);
                session.rowActionList.setSize(limit);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(list, 0, limit, session.actionTimestamp);
                this.finaliseRows(session, list, 0, limit);
            } else {
                list = session.rowActionList.toArray();
                this.addToCommittedQueue(session, list);
            }
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartTimestamp);
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int start, long timestamp) {
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                action.rollback(session, timestamp);
                int type = action.mergeRollback(session, timestamp, row);
                if (action.type == 3) {
                    if (action.deleteComplete) continue;
                    action.deleteComplete = true;
                }
                action.store.rollbackRow(session, row, type, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore store, Row row, int[] colMap) {
        RowAction action;
        Row row2 = row;
        synchronized (row2) {
            switch (table.tableType) {
                case 5: {
                    action = RowAction.addDeleteAction(session, table, row, colMap);
                    this.addTransactionInfo(row);
                    break;
                }
                case 3: {
                    action = RowAction.addDeleteAction(session, table, row, colMap);
                    store.delete(session, row);
                    row.rowAction = null;
                    break;
                }
                default: {
                    action = RowAction.addDeleteAction(session, table, row, colMap);
                }
            }
        }
        session.rowActionList.add(action);
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        if (action == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        store.indexRow(session, row);
        if (table.persistenceScope == 20) {
            row.rowAction = null;
            return;
        }
        session.rowActionList.add(action);
    }

    @Override
    public boolean canRead(Session session, PersistentStore store, Row row, int mode, int[] colMap) {
        RowAction action = row.rowAction;
        if (action == null) {
            return true;
        }
        if (action.table.tableType == 3) {
            return true;
        }
        return action.canRead(session, 0);
    }

    @Override
    public boolean canRead(Session session, PersistentStore store, long id, int mode) {
        if (store.getTable().tableType == 3) {
            return true;
        }
        RowAction action = (RowAction)this.rowActionMap.get(id);
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    @Override
    public void addTransactionInfo(CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        if (row.getTable().tableType == 5) {
            this.rowActionMap.put(object.getPos(), row.rowAction);
        }
    }

    @Override
    public void setTransactionInfo(PersistentStore store, CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        if (row.getTable().tableType == 5) {
            RowAction rowact;
            row.rowAction = rowact = (RowAction)this.rowActionMap.get(row.getPos());
        }
    }

    @Override
    public void removeTransactionInfo(CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        this.rowActionMap.remove(object.getPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionInfo(long id) {
        this.rowActionMap.getWriteLock().lock();
        try {
            RowAction action;
            RowAction rowAction = action = (RowAction)this.rowActionMap.get(id);
            synchronized (rowAction) {
                if (action.type == 0) {
                    this.rowActionMap.remove(id);
                }
            }
        }
        finally {
            this.rowActionMap.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] list) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(list);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long timestamp = this.getFirstLiveTransactionTimestamp();
        while (true) {
            long commitTimestamp = 0L;
            Object[] actions = null;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                commitTimestamp = this.committedTransactionTimestamps.getFirst();
                if (commitTimestamp >= timestamp) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                actions = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(actions, 0, actions.length, commitTimestamp);
            this.finaliseRows(session, actions, 0, actions.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
                session.isTransaction = true;
                ++this.transactionCount;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        if (session.hasLocks(cs)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean canProceed;
            if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = cs = session.statementManager.getStatement(session, cs);
                if (cs == null) {
                    return;
                }
            }
            if (canProceed = this.setWaitedSessionsTPL(session, cs)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, cs);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionStartTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                ++this.transactionCount;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void resetSession(Session session, Session targetSession, int mode) {
        super.resetSession(session, targetSession, mode);
    }

    void endTransaction(Session session) {
        long timestamp = session.transactionTimestamp;
        session.isTransaction = false;
        int index = this.liveTransactionTimestamps.indexOf(timestamp);
        if (index >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(index);
            this.mergeExpiredTransactions(session);
        }
    }
}

