/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();
    boolean isLockedMode;
    Session catalogWriteSession;
    long lockTxTs;
    long lockSessionId;
    long unlockTxTs;
    long unlockSessionId;
    int redoCount = 0;

    public TransactionManagerMVCC(Database db) {
        this.database = db;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new LongKeyHashMap(10000);
        this.txModel = 2;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 2;
    }

    @Override
    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    @Override
    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            RowAction action;
            int i;
            int limit = session.rowActionList.size();
            for (i = 0; i < limit; ++i) {
                action = (RowAction)session.rowActionList.get(i);
                if (action.canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            for (i = 0; i < limit; ++i) {
                action = (RowAction)session.rowActionList.get(i);
                action.prepareCommit(session);
            }
            for (i = 0; i < session.tempSet.size(); ++i) {
                Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object[] list;
            RowAction action;
            int i;
            int limit = session.rowActionList.size();
            for (i = 0; i < limit; ++i) {
                action = (RowAction)session.rowActionList.get(i);
                if (action.canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.endTransaction(session);
            for (i = 0; i < limit; ++i) {
                action = (RowAction)session.rowActionList.get(i);
                action.commit(session);
            }
            for (i = 0; i < session.tempSet.size(); ++i) {
                Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            int newLimit = session.rowActionList.size();
            if (newLimit > limit) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(list, limit, newLimit, session.actionTimestamp);
                this.finaliseRows(session, list, limit, newLimit);
                session.rowActionList.setSize(limit);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(list, 0, limit, session.actionTimestamp);
                this.finaliseRows(session, list, 0, limit);
            } else if (session.rowActionList.size() > 0) {
                list = session.rowActionList.toArray();
                this.addToCommittedQueue(session, list);
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int start, long timestamp) {
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                action.rollback(session, timestamp);
                int type = action.mergeRollback(session, timestamp, row);
                if (action.type == 3) {
                    if (action.deleteComplete) continue;
                    action.deleteComplete = true;
                }
                action.store.rollbackRow(session, row, type, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(start);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore store, Row row, int[] colMap) {
        RowAction action = this.addDeleteActionToRow(session, table, store, row, colMap);
        Session actionSession = null;
        boolean redoAction = true;
        if (action == null) {
            this.writeLock.lock();
            try {
                this.rollbackAction(session);
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.tempSet.clear();
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.tempSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    throw Error.error(4871);
                }
                boolean bl = redoAction = !session.tempSet.isEmpty();
                if (redoAction) {
                    actionSession = ((RowActionBase)session.tempSet.get((int)0)).session;
                    session.tempSet.clear();
                    if (actionSession != null) {
                        redoAction = this.checkDeadlock(session, actionSession);
                    }
                }
                if (redoAction) {
                    session.redoAction = true;
                    if (actionSession != null) {
                        actionSession.waitingSessions.add(session);
                        session.waitedSessions.add(actionSession);
                        session.latch.setCount(session.waitedSessions.size());
                    }
                    ++this.redoCount;
                } else {
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                }
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(action);
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        Session actionSession = null;
        boolean redoAction = false;
        boolean redoWait = true;
        HsqlException cause = null;
        if (action == null) {
            throw Error.runtimeError(458, "TXManager - null insert action ");
        }
        try {
            store.indexRow(session, row);
        }
        catch (HsqlException e) {
            if (session.tempSet.isEmpty()) {
                throw e;
            }
            redoAction = true;
            cause = e;
        }
        if (!redoAction) {
            if (table.persistenceScope == 20) {
                row.rowAction = null;
                return;
            }
            session.rowActionList.add(action);
            return;
        }
        this.writeLock.lock();
        try {
            this.rollbackAction(session);
            RowActionBase otherAction = (RowActionBase)session.tempSet.get(0);
            actionSession = otherAction.session;
            session.tempSet.clear();
            if (otherAction.commitTimestamp != 0L) {
                redoWait = false;
            }
            switch (session.isolationLevel) {
                case 4: 
                case 8: {
                    redoAction = false;
                    break;
                }
                default: {
                    redoAction = this.checkDeadlock(session, actionSession);
                }
            }
            if (redoAction) {
                session.redoAction = true;
                if (redoWait) {
                    actionSession.waitingSessions.add(session);
                    session.waitedSessions.add(actionSession);
                    session.latch.setCount(session.waitedSessions.size());
                }
                ++this.redoCount;
            } else {
                session.abortTransaction = session.txConflictRollback;
                session.redoAction = false;
            }
            throw Error.error(cause, 4871, null);
        }
        catch (Throwable throwable) {
            this.writeLock.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean canRead(Session session, PersistentStore store, Row row, int mode, int[] colMap) {
        RowAction action = row.rowAction;
        if (action == null) {
            return true;
        }
        if (action.table.tableType == 3) {
            return true;
        }
        if (mode == 0) {
            return action.canRead(session, 0);
        }
        if (mode == 2) {
            return action.canRead(session, 0);
        }
        return action.canRead(session, mode);
    }

    @Override
    public boolean canRead(Session session, PersistentStore store, long id, int mode) {
        if (store.getTable().tableType == 3) {
            return true;
        }
        RowAction action = (RowAction)this.rowActionMap.get(id);
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    @Override
    public void addTransactionInfo(CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        if (row.getTable().tableType == 5) {
            RowAction action = (RowAction)this.rowActionMap.get(object.getPos());
            if (action != null) {
                HsqlException e = Error.error(4871, "TXManager - row exists");
                this.database.logger.logSevereEvent("TXManager MVROWS", e);
                throw e;
            }
            this.rowActionMap.put(object.getPos(), row.rowAction);
        }
    }

    @Override
    public void setTransactionInfo(PersistentStore store, CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        if (row.getTable().tableType == 5) {
            RowAction rowact;
            row.rowAction = rowact = (RowAction)this.rowActionMap.get(row.getPos());
        }
    }

    @Override
    public void removeTransactionInfo(CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        if (row.getTable().tableType == 5) {
            this.rowActionMap.remove(row.getPos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionInfo(long id) {
        this.rowActionMap.getWriteLock().lock();
        try {
            RowAction action;
            RowAction rowAction = action = (RowAction)this.rowActionMap.get(id);
            synchronized (rowAction) {
                if (action.type == 0) {
                    this.rowActionMap.remove(id);
                }
            }
        }
        finally {
            this.rowActionMap.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] list) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(list);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long timestamp = this.getFirstLiveTransactionTimestamp();
        while (true) {
            Object[] actions;
            long commitTimestamp;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                commitTimestamp = this.committedTransactionTimestamps.getFirst();
                if (commitTimestamp >= timestamp) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                actions = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(actions, 0, actions.length, commitTimestamp);
            this.finaliseRows(session, actions, 0, actions.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                ++this.transactionCount;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        if (session.isTransaction) {
            return;
        }
        if (cs == null) {
            return;
        }
        this.writeLock.lock();
        try {
            if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = cs = session.statementManager.getStatement(session, cs);
                if (cs == null) {
                    return;
                }
            }
            session.isPreTransaction = true;
            if (session.abortTransaction) {
                return;
            }
            if (!this.isLockedMode && !cs.isCatalogLock()) {
                return;
            }
            this.beginActionTPL(session, cs);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionStartTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            if (session.isTransaction) {
                return;
            }
            session.transactionTimestamp = session.actionTimestamp;
            session.isTransaction = true;
            this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
            ++this.transactionCount;
            session.isPreTransaction = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowAction addDeleteActionToRow(Session session, Table table, PersistentStore store, Row row, int[] colMap) {
        RowAction action = null;
        Row row2 = row;
        synchronized (row2) {
            switch (table.tableType) {
                case 5: {
                    this.rowActionMap.getWriteLock().lock();
                    try {
                        action = (RowAction)this.rowActionMap.get(row.getPos());
                        if (action == null) {
                            action = RowAction.addDeleteAction(session, table, row, colMap);
                            if (action == null) break;
                            this.addTransactionInfo(row);
                            break;
                        }
                        row.rowAction = action;
                        action = RowAction.addDeleteAction(session, table, row, colMap);
                        break;
                    }
                    finally {
                        this.rowActionMap.getWriteLock().unlock();
                    }
                }
                case 3: {
                    action = RowAction.addDeleteAction(session, table, row, colMap);
                    store.delete(session, row);
                    row.rowAction = null;
                    break;
                }
                default: {
                    action = RowAction.addDeleteAction(session, table, row, colMap);
                }
            }
        }
        return action;
    }

    void endTransaction(Session session) {
        long timestamp = session.transactionTimestamp;
        int index = this.liveTransactionTimestamps.indexOf(timestamp);
        if (index >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(index);
            this.mergeExpiredTransactions(session);
        }
    }

    private void countDownLatches(Session session) {
        for (int i = 0; i < session.waitingSessions.size(); ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            current.waitedSessions.remove(session);
            current.latch.setCount(current.waitedSessions.size());
        }
        session.waitedSessions.clear();
        session.waitingSessions.clear();
    }

    void getTransactionSessions(HashSet set) {
        Session[] sessions = this.database.sessionManager.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            long timestamp = sessions[i].getTransactionTimestamp();
            if (sessions[i].isPreTransaction) {
                set.add(sessions[i]);
                continue;
            }
            if (!sessions[i].isTransaction) continue;
            set.add(sessions[i]);
        }
    }

    @Override
    void endTransactionTPL(Session session) {
        Session current;
        int i;
        if (this.catalogWriteSession != session) {
            return;
        }
        Session nextSession = null;
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            current = (Session)session.waitingSessions.get(i);
            Statement st = current.sessionContext.currentStatement;
            if (st == null || !st.isCatalogLock()) continue;
            nextSession = current;
            break;
        }
        if (nextSession == null) {
            this.catalogWriteSession = null;
            this.isLockedMode = false;
        } else {
            for (i = 0; i < session.waitingSessions.size(); ++i) {
                current = (Session)session.waitingSessions.get(i);
                if (current == nextSession) continue;
                current.waitedSessions.add(nextSession);
                nextSession.waitingSessions.add(current);
                current.latch.setCount(current.waitedSessions.size());
            }
            this.catalogWriteSession = nextSession;
        }
        this.unlockTxTs = session.actionTimestamp;
        this.unlockSessionId = session.getId();
    }

    boolean beginActionTPL(Session session, Statement cs) {
        if (session == this.catalogWriteSession) {
            return true;
        }
        session.tempSet.clear();
        if (cs.isCatalogLock() && this.catalogWriteSession == null) {
            this.catalogWriteSession = session;
            this.isLockedMode = true;
            this.lockTxTs = session.actionTimestamp;
            this.lockSessionId = session.getId();
            this.getTransactionSessions(session.tempSet);
            session.tempSet.remove(session);
            if (!session.tempSet.isEmpty()) {
                session.waitedSessions.addAll(session.tempSet);
                this.setWaitingSessionTPL(session);
            }
            return true;
        }
        if (!this.isLockedMode) {
            return true;
        }
        if (cs.getTableNamesForWrite().length > 0 ? cs.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME : cs.getTableNamesForRead().length > 0 && cs.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
            return true;
        }
        if (session.waitingSessions.contains(this.catalogWriteSession)) {
            return true;
        }
        if (this.catalogWriteSession.waitingSessions.add(session)) {
            session.waitedSessions.add(this.catalogWriteSession);
            session.latch.setCount(session.waitedSessions.size());
        }
        return true;
    }

    @Override
    public void resetSession(Session session, Session targetSession, int mode) {
        super.resetSession(session, targetSession, mode);
    }
}

