/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Wrapper;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultProperties;

public class JDBCStatement
extends JDBCStatementBase
implements Statement,
Wrapper {
    boolean poolable = false;

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.fetchResult(sql, 2, 2, null, null);
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        this.fetchResult(sql, 1, 2, null, null);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeResultData();
        this.batchResultOut = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.isEscapeProcessing = enable;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (seconds > Short.MAX_VALUE) {
            seconds = Short.MAX_VALUE;
        }
        this.queryTimeout = seconds;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        this.fetchResult(sql, 0, 2, null, null);
        return this.currentResultSet != null;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        this.checkClosed();
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = direction;
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.fetchSize = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public synchronized int getResultSetType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        this.checkClosed();
        if (this.isEscapeProcessing) {
            sql = this.connection.nativeSQL(sql);
        }
        if (this.batchResultOut == null) {
            this.batchResultOut = Result.newBatchedExecuteRequest();
        }
        this.batchResultOut.getNavigator().add(new Object[]{sql});
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.batchResultOut != null) {
            this.batchResultOut.getNavigator().clear();
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.generatedResult = null;
        if (this.batchResultOut == null) {
            this.batchResultOut = Result.newBatchedExecuteRequest();
        }
        int batchCount = this.batchResultOut.getNavigator().getSize();
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
            this.performPostExecute();
        }
        catch (HsqlException e) {
            this.batchResultOut.getNavigator().clear();
            throw JDBCUtil.sqlException(e);
        }
        this.batchResultOut.getNavigator().clear();
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        RowSetNavigator navigator = this.resultIn.getNavigator();
        int[] updateCounts = new int[navigator.getSize()];
        for (int i = 0; i < updateCounts.length; ++i) {
            Object[] data = navigator.getNext();
            updateCounts[i] = (Integer)data[0];
        }
        if (updateCounts.length != batchCount) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(updateCounts);
            }
            this.errorResult.getMainString();
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), updateCounts);
        }
        return updateCounts;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        return super.getMoreResults(current);
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedResultSet();
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw JDBCUtil.invalidArgument("autoGeneratedKeys");
        }
        this.fetchResult(sql, 1, autoGeneratedKeys, null, null);
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(sql, 1, 21, columnIndexes, null);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(sql, 1, 11, null, columnNames);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw JDBCUtil.invalidArgument("autoGeneratedKeys");
        }
        this.fetchResult(sql, 0, autoGeneratedKeys, null, null);
        return this.resultIn.isData();
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(sql, 0, 21, columnIndexes, null);
        return this.resultIn.isData();
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(sql, 0, 11, null, columnNames);
        return this.resultIn.isData();
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public synchronized void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public synchronized boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    JDBCStatement(JDBCConnection c, int props) {
        this.resultOut = Result.newExecuteDirectRequest();
        this.connection = c;
        this.connectionIncarnation = this.connection.incarnation;
        this.rsProperties = props;
    }

    private void fetchResult(String sql, int statementRetType, int generatedKeys, int[] generatedIndexes, String[] generatedNames) throws SQLException {
        this.checkClosed();
        this.closeResultData();
        if (this.isEscapeProcessing) {
            sql = this.connection.nativeSQL(sql);
        }
        this.resultOut.setPrepareOrExecuteProperties(sql, this.maxRows, this.fetchSize, statementRetType, this.queryTimeout, this.rsProperties, generatedKeys, generatedIndexes, generatedNames);
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
            this.performPostExecute();
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
        } else if (this.resultIn.getStatementType() == 2) {
            this.getMoreResults();
        }
    }
}

