/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.jdbc.pool.JDBCXAConnection;
import org.hsqldb.jdbc.pool.JDBCXAResource;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;

public class JDBCXADataSource
extends JDBCCommonDataSource
implements XADataSource,
Serializable,
Referenceable,
CommonDataSource {
    private HashMap resources = new HashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    @Override
    public XAConnection getXAConnection() throws SQLException {
        JDBCConnection connection = (JDBCConnection)JDBCDriver.getConnection(this.url, this.connectionProps);
        JDBCXAConnection xaConnection = new JDBCXAConnection(this, connection);
        return xaConnection;
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (user == null || password == null) {
            throw JDBCUtil.nullArgument();
        }
        if (user.equals(this.user) && password.equals(this.password)) {
            return this.getXAConnection();
        }
        throw JDBCUtil.sqlException(Error.error(4000));
    }

    @Override
    public Reference getReference() throws NamingException {
        String cname = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), cname, null);
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(Xid xid, JDBCXAResource xaResource) {
        this.lock.writeLock().lock();
        try {
            this.resources.put(xid, xaResource);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCXAResource removeResource(Xid xid) {
        this.lock.writeLock().lock();
        try {
            JDBCXAResource jDBCXAResource = (JDBCXAResource)this.resources.remove(xid);
            return jDBCXAResource;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Xid[] getPreparedXids() {
        this.lock.writeLock().lock();
        try {
            Iterator it = this.resources.keySet().iterator();
            HashSet preparedSet = new HashSet();
            while (it.hasNext()) {
                Xid curXid = (Xid)it.next();
                if (((JDBCXAResource)this.resources.get((Object)curXid)).state != JDBCXAResource.XA_STATE_PREPARED) continue;
                preparedSet.add(curXid);
            }
            Object[] array = new Xid[preparedSet.size()];
            preparedSet.toArray(array);
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDBCXAResource getResource(Xid xid) {
        this.lock.readLock().lock();
        try {
            JDBCXAResource jDBCXAResource = (JDBCXAResource)this.resources.get(xid);
            return jDBCXAResource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

