/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Comparator;

public class ArraySort {
    public static int searchFirst(Object[] array, int start, int limit, Object value, Comparator c) {
        int low = start;
        int high = limit;
        int mid = start;
        int compare = 0;
        int found = limit;
        while (low < high) {
            mid = low + high >>> 1;
            compare = c.compare(value, array[mid]);
            if (compare < 0) {
                high = mid;
                continue;
            }
            if (compare > 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
            found = mid;
        }
        return found == limit ? -low - 1 : found;
    }

    public static int deDuplicate(Object[] array, int start, int limit, Comparator comparator) {
        int baseIndex = start;
        if (array.length == 0) {
            return 0;
        }
        for (int currentIndex = start + 1; currentIndex < limit; ++currentIndex) {
            int compare = comparator.compare(array[baseIndex], array[currentIndex]);
            if (compare == 0) continue;
            array[++baseIndex] = array[currentIndex];
        }
        return baseIndex + 1;
    }

    public static void sort(Object[] array, int start, int limit, Comparator comparator) {
        if (start + 1 >= limit) {
            return;
        }
        ArraySort.quickSort(array, comparator, start, limit - 1);
        ArraySort.insertionSort(array, comparator, start, limit - 1);
    }

    static void quickSort(Object[] array, Comparator comparator, int l, int r) {
        int M = 16;
        if (r - l > M) {
            int i = r + l >>> 1;
            if (comparator.compare(array[i], array[l]) < 0) {
                ArraySort.swap(array, l, i);
            }
            if (comparator.compare(array[r], array[l]) < 0) {
                ArraySort.swap(array, l, r);
            }
            if (comparator.compare(array[r], array[i]) < 0) {
                ArraySort.swap(array, i, r);
            }
            int j = r - 1;
            ArraySort.swap(array, i, j);
            i = l;
            int v = j;
            while (true) {
                if (comparator.compare(array[++i], array[v]) < 0) {
                    continue;
                }
                while (comparator.compare(array[v], array[--j]) < 0) {
                }
                if (j < i) break;
                ArraySort.swap(array, i, j);
            }
            ArraySort.swap(array, i, r - 1);
            ArraySort.quickSort(array, comparator, l, j);
            ArraySort.quickSort(array, comparator, i + 1, r);
        }
    }

    public static void insertionSort(Object[] array, Comparator comparator, int lo0, int hi0) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            int j;
            for (j = i; j > lo0 && comparator.compare(array[i], array[j - 1]) < 0; --j) {
            }
            if (i == j) continue;
            ArraySort.moveAndInsertRow(array, i, j);
        }
    }

    private static void swap(Object[] array, int i1, int i2) {
        Object val = array[i1];
        array[i1] = array[i2];
        array[i2] = val;
    }

    private static void moveAndInsertRow(Object[] array, int i, int j) {
        Object val = array[i];
        ArraySort.moveRows(array, j, j + 1, i - j);
        array[j] = val;
    }

    private static void moveRows(Object[] array, int fromIndex, int toIndex, int rows) {
        System.arraycopy(array, fromIndex, array, toIndex, rows);
    }
}

