/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.lib.InputStreamInterface;

public class InputStreamWrapper
implements InputStreamInterface {
    InputStream is;
    long limitSize = -1L;
    long fetchedSize = 0L;

    public InputStreamWrapper(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        if (this.fetchedSize == this.limitSize) {
            return -1;
        }
        int byteread = this.is.read();
        if (byteread < 0) {
            if (this.limitSize == -1L) {
                return -1;
            }
            throw new IOException("stream not reached the end" + this.fetchedSize + " " + this.limitSize);
        }
        ++this.fetchedSize;
        return byteread;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int count;
        if (this.fetchedSize == this.limitSize) {
            return -1;
        }
        if (this.limitSize >= 0L && this.limitSize - this.fetchedSize < (long)length) {
            length = (int)(this.limitSize - this.fetchedSize);
        }
        if ((count = this.is.read(bytes, offset, length)) < 0) {
            if (this.limitSize == -1L) {
                return -1;
            }
            throw new IOException("stream not reached the end" + this.fetchedSize + " " + this.limitSize);
        }
        this.fetchedSize += (long)count;
        return count;
    }

    @Override
    public long skip(long count) throws IOException {
        return this.is.skip(count);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void setSizeLimit(long count) {
        this.limitSize = count;
    }

    @Override
    public long getSizeLimit() {
        return this.limitSize;
    }
}

