/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyIntValueHashMap
extends BaseHashMap {
    private Set keySet;
    private Collection values;

    public IntKeyIntValueHashMap() {
        this(8);
    }

    public IntKeyIntValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 1, false);
    }

    public int get(int key) throws NoSuchElementException {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public int get(int key, int defaultValue) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(int key, int[] value) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.intValueTable[lookup];
            return true;
        }
        return false;
    }

    public boolean put(int key, int value) {
        int oldSize = this.size();
        super.addOrRemove(key, value, null, null, false);
        return oldSize != this.size();
    }

    public boolean remove(int key) {
        int oldSize = this.size();
        super.addOrRemove(key, 0L, null, null, true);
        return oldSize != this.size();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            intKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            IntKeyIntValueHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            intKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            IntKeyIntValueHashMap.this.clear();
        }
    }
}

