/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.LineNumberReader;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.map.ValuePool;

public class LineGroupReader {
    private static final String[] defaultContinuations = new String[]{" ", "*"};
    private static final String[] defaultIgnoredStarts = new String[]{"--"};
    static final String LS = System.getProperty("line.separator", "\n");
    LineNumberReader reader;
    String nextStartLine = null;
    int startLineNumber = 0;
    int nextStartLineNumber = 0;
    final String[] sectionContinuations;
    final String[] sectionStarts;
    final String[] ignoredStarts;

    public LineGroupReader(LineNumberReader reader) {
        this.sectionContinuations = defaultContinuations;
        this.sectionStarts = ValuePool.emptyStringArray;
        this.ignoredStarts = defaultIgnoredStarts;
        this.reader = reader;
        try {
            this.getSection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LineGroupReader(LineNumberReader reader, String[] sectionStarts) {
        this.sectionStarts = sectionStarts;
        this.sectionContinuations = ValuePool.emptyStringArray;
        this.ignoredStarts = ValuePool.emptyStringArray;
        this.reader = reader;
        try {
            this.getSection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HsqlArrayList getSection() {
        HsqlArrayList list = new HsqlArrayList(new String[8], 0);
        if (this.nextStartLine != null) {
            list.add(this.nextStartLine);
            this.startLineNumber = this.nextStartLineNumber;
        }
        while (true) {
            boolean newSection = false;
            String line = null;
            try {
                line = this.reader.readLine();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (line == null) {
                this.nextStartLine = null;
                return list;
            }
            if ((line = line.substring(0, StringUtil.rightTrimSize(line))).length() == 0 || this.isIgnoredLine(line)) continue;
            if (this.isNewSectionLine(line)) {
                newSection = true;
            }
            if (newSection) {
                this.nextStartLine = line;
                this.nextStartLineNumber = this.reader.getLineNumber();
                return list;
            }
            list.add(line);
        }
    }

    public HashMappedList getAsMap() {
        HsqlArrayList list;
        HashMappedList map = new HashMappedList();
        while ((list = this.getSection()).size() >= 1) {
            String key = (String)list.get(0);
            String value = LineGroupReader.convertToString(list, 1);
            map.put(key, value);
        }
        return map;
    }

    private boolean isNewSectionLine(String line) {
        if (this.sectionStarts.length == 0) {
            for (int i = 0; i < this.sectionContinuations.length; ++i) {
                if (!line.startsWith(this.sectionContinuations[i])) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.sectionStarts.length; ++i) {
            if (!line.startsWith(this.sectionStarts[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnoredLine(String line) {
        for (int i = 0; i < this.ignoredStarts.length; ++i) {
            if (!line.startsWith(this.ignoredStarts[i])) continue;
            return true;
        }
        return false;
    }

    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String convertToString(HsqlArrayList list, int offset) {
        StringBuffer sb = new StringBuffer();
        for (int i = offset; i < list.size(); ++i) {
            sb.append(list.get(i)).append(LS);
        }
        return sb.toString();
    }
}

