/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongValueHashMap
extends BaseHashMap {
    Set keySet;

    public LongValueHashMap() {
        this(8);
    }

    public LongValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 2, false);
    }

    public long get(Object key) throws NoSuchElementException {
        if (key == null) {
            throw new NoSuchElementException();
        }
        int hash = key.hashCode();
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            return this.longValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public long get(Object key, int defaultValue) {
        if (key == null) {
            throw new NoSuchElementException();
        }
        int hash = key.hashCode();
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            return this.longValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(Object key, long[] value) {
        if (key == null) {
            throw new NoSuchElementException();
        }
        int hash = key.hashCode();
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            value[0] = this.longValueTable[lookup];
            return true;
        }
        return false;
    }

    public Object getKey(long value) {
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this, false);
        while (it.hasNext()) {
            long i = it.nextLong();
            if (i != value) continue;
            return this.objectKeyTable[it.getLookup()];
        }
        return null;
    }

    public boolean put(Object key, long value) {
        if (key == null) {
            throw new NoSuchElementException();
        }
        int oldSize = this.size();
        super.addOrRemove(0L, value, key, null, false);
        return oldSize != this.size();
    }

    public boolean remove(Object key) {
        int oldSize = this.size();
        super.addOrRemove(0L, 0L, key, null, true);
        return oldSize != this.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public void putAll(LongValueHashMap t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            LongValueHashMap longValueHashMap = LongValueHashMap.this;
            longValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longValueHashMap, true);
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return LongValueHashMap.this.containsKey(o);
        }

        @Override
        public Object get(Object key) {
            int lookup = LongValueHashMap.this.getLookup(key, key.hashCode());
            if (lookup < 0) {
                return null;
            }
            return LongValueHashMap.this.objectKeyTable[lookup];
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            LongValueHashMap.this.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongValueHashMap.this.clear();
        }
    }
}

