/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorClient
extends RowSetNavigator {
    public static final Object[][] emptyTable = new Object[0][];
    int currentOffset;
    int baseBlockSize;
    Object[][] table;

    public RowSetNavigatorClient() {
        this.table = emptyTable;
    }

    public RowSetNavigatorClient(int blockSize) {
        this.table = new Object[blockSize][];
    }

    public RowSetNavigatorClient(RowSetNavigator source, int offset, int blockSize) {
        this.size = source.size;
        this.baseBlockSize = blockSize;
        this.currentOffset = offset;
        this.table = new Object[blockSize][];
        source.absolute(offset);
        for (int count = 0; count < blockSize; ++count) {
            this.table[count] = source.getCurrent();
            source.next();
        }
        source.beforeFirst();
    }

    public void setData(Object[][] table) {
        this.table = table;
        this.size = table.length;
    }

    public void setData(int index, Object[] data) {
        this.table[index] = data;
    }

    public Object[] getData(int index) {
        return this.table[index];
    }

    @Override
    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        if (this.currentPos == this.currentOffset + this.table.length) {
            this.getBlock(this.currentOffset + this.table.length);
        }
        return this.table[this.currentPos - this.currentOffset];
    }

    @Override
    public Row getCurrentRow() {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    @Override
    public void removeCurrent() {
        System.arraycopy(this.table, this.currentPos + 1, this.table, this.currentPos, this.size - this.currentPos - 1);
        this.table[this.size - 1] = null;
        --this.currentPos;
        --this.size;
    }

    @Override
    public void add(Object[] data) {
        this.ensureCapacity();
        this.table[this.size] = data;
        ++this.size;
    }

    @Override
    public boolean addRow(Row row) {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    @Override
    public void clear() {
        this.setData(emptyTable);
        this.reset();
    }

    @Override
    public void release() {
        this.setData(emptyTable);
        this.reset();
    }

    @Override
    public boolean absolute(int position) {
        if (position < 0) {
            position += this.size;
        }
        if (position < 0) {
            this.beforeFirst();
            return false;
        }
        if (position >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        this.currentPos = position;
        return true;
    }

    @Override
    public void readSimple(RowInputInterface in, ResultMetaData meta) {
        this.size = in.readInt();
        if (this.table.length < this.size) {
            this.table = new Object[this.size][];
        }
        for (int i = 0; i < this.size; ++i) {
            this.table[i] = in.readData(meta.columnTypes);
        }
    }

    @Override
    public void writeSimple(RowOutputInterface out, ResultMetaData meta) {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            Object[] data = this.table[i];
            out.writeData(meta.getColumnCount(), meta.columnTypes, data, null, null);
        }
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) {
        this.id = in.readLong();
        this.size = in.readInt();
        this.currentOffset = in.readInt();
        this.baseBlockSize = in.readInt();
        if (this.table.length < this.baseBlockSize) {
            this.table = new Object[this.baseBlockSize][];
        }
        for (int i = 0; i < this.baseBlockSize; ++i) {
            this.table[i] = in.readData(meta.columnTypes);
        }
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) {
        int limit = this.size - this.currentOffset;
        if (limit > this.table.length) {
            limit = this.table.length;
        }
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(this.currentOffset);
        out.writeInt(limit);
        for (int i = 0; i < limit; ++i) {
            Object[] data = this.table[i];
            out.writeData(meta.getColumnCount(), meta.columnTypes, data, null, null);
        }
    }

    void getBlock(int offset) {
        try {
            RowSetNavigatorClient source = this.session.getRows(this.id, offset, this.baseBlockSize);
            this.table = source.table;
            this.currentOffset = source.currentOffset;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    private void ensureCapacity() {
        if (this.size == this.table.length) {
            int newSize = this.size == 0 ? 4 : this.size * 2;
            Object[][] newTable = new Object[newSize][];
            System.arraycopy(this.table, 0, newTable, 0, this.size);
            this.table = newTable;
        }
    }
}

