/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;

public class PersistentStoreCollectionSession
implements PersistentStoreCollection {
    private final Session session;
    private final LongKeyHashMap rowStoreMapSession = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapTransaction = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapStatement = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapRoutine = new LongKeyHashMap();
    private HsqlDeque rowStoreListStack;
    DataFileCacheSession resultCache;

    public PersistentStoreCollectionSession(Session session) {
        this.session = session;
    }

    @Override
    public synchronized void removeStore(TableBase table) {
        switch (table.persistenceScope) {
            case 20: {
                this.rowStoreMapRoutine.remove(table.getPersistenceId());
                break;
            }
            case 21: {
                this.rowStoreMapStatement.remove(table.getPersistenceId());
                break;
            }
            case 22: 
            case 24: {
                this.rowStoreMapTransaction.remove(table.getPersistenceId());
                break;
            }
            case 23: {
                this.rowStoreMapSession.remove(table.getPersistenceId());
                break;
            }
            default: {
                throw Error.runtimeError(201, "PersistentStoreCollectionSession");
            }
        }
    }

    public synchronized PersistentStore getViewStore(long persistenceId) {
        return (PersistentStore)this.rowStoreMapStatement.get(persistenceId);
    }

    @Override
    public synchronized PersistentStore getStore(TableBase table) {
        switch (table.persistenceScope) {
            case 20: {
                PersistentStore store = (PersistentStore)this.rowStoreMapRoutine.get(table.getPersistenceId());
                if (store == null) {
                    store = this.session.database.logger.newStore(this.session, this, table);
                    this.rowStoreMapRoutine.put(table.getPersistenceId(), store);
                }
                return store;
            }
            case 21: {
                PersistentStore store = (PersistentStore)this.rowStoreMapStatement.get(table.getPersistenceId());
                if (store == null) {
                    store = this.session.database.logger.newStore(this.session, this, table);
                    this.rowStoreMapStatement.put(table.getPersistenceId(), store);
                }
                return store;
            }
            case 22: 
            case 24: {
                PersistentStore store = (PersistentStore)this.rowStoreMapTransaction.get(table.getPersistenceId());
                if (store == null) {
                    store = this.session.database.logger.newStore(this.session, this, table);
                    this.rowStoreMapTransaction.put(table.getPersistenceId(), store);
                }
                if (table.getTableType() == 1) {
                    this.session.database.dbInfo.setStore(this.session, (Table)table, store);
                }
                return store;
            }
            case 23: {
                PersistentStore store = (PersistentStore)this.rowStoreMapSession.get(table.getPersistenceId());
                if (store == null) {
                    store = this.session.database.logger.newStore(this.session, this, table);
                    this.rowStoreMapSession.put(table.getPersistenceId(), store);
                }
                return store;
            }
        }
        throw Error.runtimeError(201, "PersistentStoreCollectionSession");
    }

    public synchronized void clearAllTables() {
        this.clearSessionTables();
        this.clearTransactionTables();
        this.clearStatementTables();
        this.clearRoutineTables();
        this.closeSessionDataCache();
    }

    public synchronized void clearResultTables(long actionTimestamp) {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapSession.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            if (store.getTimestamp() != actionTimestamp) continue;
            store.release();
            it.remove();
        }
    }

    public synchronized void clearSessionTables() {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapSession.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapSession.clear();
    }

    public synchronized void clearTransactionTables() {
        if (this.rowStoreMapTransaction.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapTransaction.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapTransaction.clear();
    }

    public synchronized void clearStatementTables() {
        if (this.rowStoreMapStatement.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapStatement.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapStatement.clear();
    }

    public synchronized void clearRoutineTables() {
        if (this.rowStoreMapRoutine.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapRoutine.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapRoutine.clear();
    }

    public synchronized PersistentStore findStore(TableBase table) {
        PersistentStore store = null;
        switch (table.persistenceScope) {
            case 20: {
                store = (PersistentStore)this.rowStoreMapRoutine.get(table.getPersistenceId());
                break;
            }
            case 21: {
                store = (PersistentStore)this.rowStoreMapStatement.get(table.getPersistenceId());
                break;
            }
            case 22: 
            case 24: {
                store = (PersistentStore)this.rowStoreMapTransaction.get(table.getPersistenceId());
                break;
            }
            case 23: {
                store = (PersistentStore)this.rowStoreMapSession.get(table.getPersistenceId());
            }
        }
        return store;
    }

    public synchronized void resetAccessorKeys(Session session, Table table, Index[] indexes) {
        PersistentStore store = this.findStore(table);
        if (store == null) {
            return;
        }
        store.resetAccessorKeys(session, indexes);
    }

    public synchronized void moveData(Table oldTable, Table newTable, int colIndex, int adjust) {
        PersistentStore store = this.findStore(oldTable);
        if (store == null) {
            return;
        }
        PersistentStore newStore = this.getStore(newTable);
        try {
            newStore.moveData(this.session, store, colIndex, adjust);
        }
        catch (HsqlException e) {
            newStore.release();
            this.removeStore(newTable);
            throw e;
        }
        this.removeStore(oldTable);
    }

    public synchronized void push(boolean isRoutine) {
        if (this.rowStoreListStack == null) {
            this.rowStoreListStack = new HsqlDeque();
        }
        Object[] array = this.rowStoreMapStatement.toArray();
        this.rowStoreListStack.add(array);
        this.rowStoreMapStatement.clear();
        if (isRoutine) {
            array = this.rowStoreMapRoutine.toArray();
            this.rowStoreListStack.add(array);
            this.rowStoreMapRoutine.clear();
        }
    }

    public synchronized void pop(boolean isRoutine) {
        PersistentStore store;
        int i;
        Object[] array;
        if (isRoutine) {
            array = (Object[])this.rowStoreListStack.removeLast();
            this.clearRoutineTables();
            for (i = 0; i < array.length; ++i) {
                store = (PersistentStore)array[i];
                this.rowStoreMapRoutine.put(store.getTable().getPersistenceId(), store);
            }
        }
        array = (Object[])this.rowStoreListStack.removeLast();
        this.clearStatementTables();
        for (i = 0; i < array.length; ++i) {
            store = (PersistentStore)array[i];
            this.rowStoreMapStatement.put(store.getTable().getPersistenceId(), store);
        }
    }

    public synchronized DataFileCacheSession getSessionDataCache() {
        if (this.resultCache == null) {
            String path = this.session.database.logger.getTempDirectoryPath();
            if (path == null) {
                return null;
            }
            try {
                this.resultCache = new DataFileCacheSession(this.session.database, path + "/session_" + Long.toString(this.session.getId()));
                this.resultCache.open(false);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return this.resultCache;
    }

    private void closeSessionDataCache() {
        if (this.resultCache != null) {
            try {
                this.resultCache.release();
                this.resultCache.deleteFile();
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.resultCache = null;
        }
    }

    @Override
    public synchronized void release() {
        this.clearAllTables();
    }
}

