/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RandomAccessInterface;

public class RAShadowFile {
    private static final int headerSize = 12;
    final Database database;
    final String pathName;
    final RandomAccessInterface source;
    RandomAccessInterface dest;
    final int pageSize;
    final long maxSize;
    final BitMap bitMap;
    boolean zeroPageSet;
    long savedLength;
    long synchLength;
    byte[] buffer;
    HsqlByteArrayOutputStream byteArrayOutputStream;

    RAShadowFile(Database database, RandomAccessInterface source, String pathName, long maxSize, int pageSize) {
        this.database = database;
        this.pathName = pathName;
        this.source = source;
        this.pageSize = pageSize;
        this.maxSize = maxSize;
        int bitSize = (int)(maxSize / (long)pageSize);
        if (maxSize % (long)pageSize != 0L) {
            ++bitSize;
        }
        this.bitMap = new BitMap(bitSize, false);
        this.buffer = new byte[pageSize + 12];
        this.byteArrayOutputStream = new HsqlByteArrayOutputStream(this.buffer);
    }

    int copy(long fileOffset, int size) throws IOException {
        int pageCount = 0;
        if (!this.zeroPageSet) {
            pageCount += this.copy(0);
            this.bitMap.set(0);
            this.zeroPageSet = true;
        }
        if (fileOffset >= this.maxSize) {
            return pageCount;
        }
        long endOffset = fileOffset + (long)size;
        if (endOffset > this.maxSize) {
            endOffset = this.maxSize;
        }
        int startPageOffset = (int)(fileOffset / (long)this.pageSize);
        int endPageOffset = (int)(endOffset / (long)this.pageSize);
        if (endOffset % (long)this.pageSize == 0L) {
            --endPageOffset;
        }
        while (startPageOffset <= endPageOffset) {
            pageCount += this.copy(startPageOffset);
            ++startPageOffset;
        }
        return pageCount;
    }

    private int copy(int pageOffset) throws IOException {
        if (this.bitMap.set(pageOffset) == 1) {
            return 0;
        }
        long position = (long)pageOffset * (long)this.pageSize;
        int readSize = this.pageSize;
        int writeSize = this.buffer.length;
        if (this.maxSize - position < (long)this.pageSize) {
            readSize = (int)(this.maxSize - position);
        }
        if (this.dest == null) {
            this.open();
        }
        long writePos = this.dest.length();
        try {
            this.byteArrayOutputStream.reset();
            if (readSize < this.pageSize) {
                this.byteArrayOutputStream.fill(0, this.buffer.length);
                this.byteArrayOutputStream.reset();
            }
            this.byteArrayOutputStream.writeInt(this.pageSize);
            this.byteArrayOutputStream.writeLong(position);
            this.source.seek(position);
            this.source.read(this.buffer, 12, readSize);
            this.dest.seek(writePos);
            this.dest.write(this.buffer, 0, writeSize);
            this.savedLength = writePos + (long)writeSize;
            return 1;
        }
        catch (Throwable t) {
            this.bitMap.unset(pageOffset);
            this.dest.seek(0L);
            this.dest.setLength(writePos);
            this.close();
            this.database.logger.logSevereEvent("shadow backup failure pos " + position + " " + readSize, t);
            throw JavaSystem.toIOException(t);
        }
    }

    private void open() throws IOException {
        this.dest = this.database.logger.isStoredFileAccess() ? RAFile.newScaledRAFile(this.database, this.pathName, false, 3) : new RAFileSimple(this.database.logger, this.pathName, "rw");
    }

    void close() throws IOException {
        if (this.dest != null) {
            this.dest.synch();
            this.dest.close();
            this.dest = null;
        }
    }

    public void synch() {
        if (this.dest != null) {
            this.dest.synch();
            this.synchLength = this.savedLength;
        }
    }

    public long getSavedLength() {
        return this.savedLength;
    }

    public InputStreamInterface getInputStream() {
        return new InputStreamShadow();
    }

    private static RandomAccessInterface getStorage(Database database, String pathName, String openMode) throws IOException {
        if (database.logger.isStoredFileAccess()) {
            return RAFile.newScaledRAFile(database, pathName, openMode.equals("r"), 3);
        }
        return new RAFileSimple(database.logger, pathName, openMode);
    }

    public static void restoreFile(Database database, String sourceName, String destName) throws IOException {
        RandomAccessInterface source = RAShadowFile.getStorage(database, sourceName, "r");
        RandomAccessInterface dest = RAShadowFile.getStorage(database, destName, "rw");
        while (source.getFilePointer() != source.length()) {
            int size = source.readInt();
            long position = source.readLong();
            byte[] buffer = new byte[size];
            source.read(buffer, 0, buffer.length);
            dest.seek(position);
            dest.write(buffer, 0, buffer.length);
        }
        source.close();
        dest.synch();
        dest.close();
    }

    class InputStreamShadow
    implements InputStreamInterface {
        FileInputStream is;
        long limitSize = 0L;
        long fetchedSize = 0L;
        boolean initialised = false;

        InputStreamShadow() {
        }

        @Override
        public int read() throws IOException {
            if (!this.initialised) {
                this.initialise();
            }
            if (this.fetchedSize == this.limitSize) {
                return -1;
            }
            int byteread = this.is.read();
            if (byteread < 0) {
                throw new IOException("backup file not complete " + this.fetchedSize + " " + this.limitSize);
            }
            ++this.fetchedSize;
            return byteread;
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            int count;
            if (!this.initialised) {
                this.initialise();
            }
            if (this.fetchedSize == this.limitSize) {
                return -1;
            }
            if (this.limitSize >= 0L && this.limitSize - this.fetchedSize < (long)length) {
                length = (int)(this.limitSize - this.fetchedSize);
            }
            if ((count = this.is.read(bytes, offset, length)) < 0) {
                throw new IOException("backup file not complete " + this.fetchedSize + " " + this.limitSize);
            }
            this.fetchedSize += (long)count;
            return count;
        }

        @Override
        public long skip(long count) throws IOException {
            return 0L;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
        }

        @Override
        public void setSizeLimit(long count) {
            this.limitSize = count;
        }

        @Override
        public long getSizeLimit() {
            if (!this.initialised) {
                this.initialise();
            }
            return this.limitSize;
        }

        private void initialise() {
            this.limitSize = RAShadowFile.this.synchLength;
            RAShadowFile.this.database.logger.logDetailEvent("shadow file size for backup: " + this.limitSize);
            if (this.limitSize > 0L) {
                try {
                    this.is = new FileInputStream(RAShadowFile.this.pathName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            this.initialised = true;
        }
    }
}

