/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.Type;

public abstract class RowStoreAVL
implements PersistentStore {
    Database database;
    PersistentStoreCollection manager;
    TableSpaceManager tableSpace;
    Index[] indexList = Index.emptyArray;
    CachedObject[] accessorList = CachedObject.emptyArray;
    TableBase table;
    long baseElementCount;
    AtomicLong elementCount = new AtomicLong();
    long storageSize;
    boolean[] nullsList;
    double[][] searchCost;
    boolean isSchemaStore;
    private long timestamp;
    PersistentStore[] subStores = PersistentStore.emptyArray;

    public boolean isRowStore() {
        return true;
    }

    public boolean isRowSet() {
        return false;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public abstract boolean isMemory();

    @Override
    public void setMemory(boolean mode) {
    }

    @Override
    public abstract int getAccessCount();

    @Override
    public abstract void set(CachedObject var1);

    @Override
    public abstract CachedObject get(long var1, boolean var3);

    @Override
    public abstract CachedObject get(CachedObject var1, boolean var2);

    public CachedObject getRow(long key, boolean[] usedColumnCheck) {
        return this.get(key, false);
    }

    public int compare(Session session, long key) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public abstract void add(Session var1, CachedObject var2, boolean var3);

    @Override
    public final void add(CachedObject object, boolean keep) {
    }

    @Override
    public boolean canRead(Session session, long pos, int mode, int[] colMap) {
        return true;
    }

    @Override
    public boolean canRead(Session session, CachedObject object, int mode, int[] colMap) {
        RowAction action = ((Row)object).rowAction;
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    @Override
    public abstract CachedObject get(RowInputInterface var1);

    @Override
    public CachedObject get(CachedObject object, RowInputInterface in) {
        return object;
    }

    @Override
    public CachedObject getNewInstance(int size) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public int getDefaultObjectSize() {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public abstract CachedObject getNewCachedObject(Session var1, Object var2, boolean var3);

    @Override
    public abstract void removeAll();

    @Override
    public abstract void remove(CachedObject var1);

    @Override
    public abstract void commitPersistence(CachedObject var1);

    @Override
    public abstract void postCommitAction(Session var1, RowAction var2);

    @Override
    public abstract DataFileCache getCache();

    @Override
    public TableSpaceManager getSpaceManager() {
        return this.tableSpace;
    }

    @Override
    public void setSpaceManager(TableSpaceManager manager) {
        this.tableSpace = manager;
    }

    @Override
    public abstract void setCache(DataFileCache var1);

    @Override
    public abstract void release();

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[position];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Session session, Row row) {
        int i;
        for (i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].delete(session, this, row);
        }
        for (i = 0; i < this.subStores.length; ++i) {
            this.subStores[i].delete(session, row);
        }
        row.delete(this);
        long count = this.elementCount.decrementAndGet();
        if (count > 16384L && count < this.baseElementCount / 2L) {
            RowStoreAVL rowStoreAVL = this;
            synchronized (rowStoreAVL) {
                this.baseElementCount = count;
                this.searchCost = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexRow(Session session, Row row) {
        block13: {
            int i;
            try {
                for (i = 0; i < this.indexList.length; ++i) {
                    this.indexList[i].insert(session, this, row);
                }
                int j = 0;
                try {
                    for (j = 0; j < this.subStores.length; ++j) {
                        this.subStores[j].indexRow(session, row);
                    }
                }
                catch (HsqlException e) {
                    int count = j;
                    for (j = 0; j < count; ++j) {
                        this.subStores[j].delete(session, row);
                    }
                    throw e;
                }
                long count = this.elementCount.incrementAndGet();
                if (count <= 16384L || count <= this.baseElementCount * 2L) break block13;
                RowStoreAVL rowStoreAVL = this;
                synchronized (rowStoreAVL) {
                    this.baseElementCount = count;
                    this.searchCost = null;
                }
            }
            catch (HsqlException e) {
                int count = i;
                for (i = 0; i < count; ++i) {
                    this.indexList[i].delete(session, this, row);
                }
                this.remove(row);
                throw e;
            }
            catch (Throwable t) {
                int count = i;
                for (i = 0; i < count; ++i) {
                    this.indexList[i].delete(session, this, row);
                }
                throw Error.error(458, t);
            }
        }
    }

    @Override
    public final void indexRows(Session session) {
        for (int i = 1; i < this.indexList.length; ++i) {
            this.setAccessor(this.indexList[i], null);
        }
        RowIterator it = this.rowIterator();
        while (it.hasNext()) {
            Row row = it.getNextRow();
            ((RowAVL)row).clearNonPrimaryNodes();
            for (int i = 1; i < this.indexList.length; ++i) {
                this.indexList[i].insert(session, this, row);
            }
        }
    }

    @Override
    public final RowIterator rowIterator() {
        Index index = this.indexList[0];
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            index = this.indexList[i];
            break;
        }
        return index.firstRow(this);
    }

    @Override
    public void setAccessor(Index key, CachedObject accessor) {
        Index index = key;
        this.accessorList[index.getPosition()] = accessor;
    }

    @Override
    public void setAccessor(Index key, long accessor) {
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] keys) {
        int position;
        Index[] oldIndexList = this.indexList;
        this.searchCost = null;
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.indexList == keys) {
            return;
        }
        CachedObject[] oldAccessors = this.accessorList;
        int limit = this.indexList.length;
        int diff = keys.length - this.indexList.length;
        if (diff < -1) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        if (diff == -1) {
            limit = keys.length;
        } else {
            if (diff == 0) {
                return;
            }
            if (diff != 1) {
                for (position = 0; position < limit && this.indexList[position] == keys[position]; ++position) {
                }
                Index[] tempKeys = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, position, 1);
                tempKeys[position] = keys[position];
                this.resetAccessorKeys(session, tempKeys);
                this.resetAccessorKeys(session, keys);
                return;
            }
        }
        while (position < limit && this.indexList[position] == keys[position]) {
            ++position;
        }
        this.accessorList = (CachedObject[])ArrayUtil.toAdjustedArray(this.accessorList, null, position, diff);
        this.indexList = keys;
        try {
            if (diff > 0) {
                this.insertIndexNodes(session, this.indexList[0], this.indexList[position]);
            } else {
                this.dropIndexFromRows(this.indexList[0], oldIndexList[position]);
            }
        }
        catch (HsqlException e) {
            this.accessorList = oldAccessors;
            this.indexList = oldIndexList;
            throw e;
        }
    }

    @Override
    public Index[] getAccessorKeys() {
        return this.indexList;
    }

    @Override
    public synchronized double searchCost(Session session, Index index, int count, int opType) {
        if (count == 0) {
            return this.elementCount.get();
        }
        if (opType != 40) {
            return (double)this.elementCount.get() / 2.0;
        }
        if (index.isUnique() && count == index.getColumnCount()) {
            return 1.0;
        }
        int position = index.getPosition();
        if (this.searchCost == null || this.searchCost.length != this.indexList.length) {
            this.searchCost = new double[this.indexList.length][];
        }
        if (this.searchCost[position] == null) {
            this.searchCost[position] = this.indexList[position].searchCost(session, this);
        }
        return this.searchCost[index.getPosition()][count - 1];
    }

    @Override
    public long elementCount() {
        Index index = this.indexList[0];
        if (this.elementCount.get() < 0L) {
            this.elementCount.set(index.getNodeCount(null, this));
        }
        return this.elementCount.get();
    }

    @Override
    public long elementCount(Session session) {
        int txControl;
        Index index = this.indexList[0];
        if (this.elementCount.get() < 0L) {
            this.elementCount.set(index.getNodeCount(session, this));
        }
        if (session != null && (txControl = session.database.txManager.getTransactionControl()) != 0) {
            switch (this.table.getTableType()) {
                case 4: 
                case 5: 
                case 7: {
                    return index.getNodeCount(session, this);
                }
            }
        }
        return this.elementCount.get();
    }

    @Override
    public long elementCountUnique(Index index) {
        return 0L;
    }

    @Override
    public void setElementCount(Index key, long size, long uniqueSize) {
        this.elementCount.set(size);
    }

    @Override
    public boolean hasNull(int pos) {
        return false;
    }

    @Override
    public void moveDataToSpace(Session session) {
    }

    @Override
    public final void moveData(Session session, PersistentStore other, int colindex, int adjust) {
        Type oldtype = null;
        Type newtype = null;
        Object colvalue = null;
        if (adjust >= 0 && colindex != -1) {
            ColumnSchema column = ((Table)this.table).getColumn(colindex);
            colvalue = column.getDefaultValue(session);
            newtype = ((Table)this.table).getColumnTypes()[colindex];
        }
        if (adjust <= 0 && colindex != -1) {
            oldtype = ((Table)other.getTable()).getColumnTypes()[colindex];
        }
        try {
            Object[] olddata;
            Row row;
            Table table = (Table)this.table;
            RowIterator it = other.rowIterator();
            while (it.hasNext()) {
                row = it.getNextRow();
                olddata = row.getData();
                Object[] data = table.getEmptyRowData();
                Object oldvalue = null;
                if (adjust == 0 && colindex != -1) {
                    oldvalue = olddata[colindex];
                    colvalue = newtype.convertToType(session, oldvalue, oldtype);
                }
                ArrayUtil.copyAdjustArray(olddata, data, colvalue, colindex, adjust);
                table.systemSetIdentityColumn(session, data);
                if (table.hasGeneratedColumn()) {
                    table.setGeneratedColumns(session, data);
                }
                table.enforceTypeLimits(session, data);
                table.enforceRowConstraints(session, data);
                Row newrow = (Row)this.getNewCachedObject(session, data, false);
                this.indexRow(session, newrow);
            }
            if (table.isTemp()) {
                return;
            }
            if (oldtype != null && oldtype.isLobType()) {
                it = other.rowIterator();
                while (it.hasNext()) {
                    row = it.getNextRow();
                    olddata = row.getData();
                    Object oldvalue = olddata[colindex];
                    if (oldvalue == null) continue;
                    session.sessionData.adjustLobUsageCount(oldvalue, -1);
                }
            }
            if (newtype != null && newtype.isLobType()) {
                it = this.rowIterator();
                while (it.hasNext()) {
                    row = it.getNextRow();
                    Object[] data = row.getData();
                    Object value = data[colindex];
                    if (value == null) continue;
                    session.sessionData.adjustLobUsageCount(value, 1);
                }
            }
        }
        catch (OutOfMemoryError e) {
            throw Error.error(460);
        }
    }

    @Override
    public void reindex(Session session, Index index) {
        this.setAccessor(index, null);
        RowIterator it = this.table.rowIterator(this);
        while (it.hasNext()) {
            RowAVL row = (RowAVL)it.getNextRow();
            row.getNode(index.getPosition()).delete();
            index.insert(session, this, row);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public void readLock() {
    }

    @Override
    public void readUnlock() {
    }

    @Override
    public void writeLock() {
    }

    @Override
    public void writeUnlock() {
    }

    void dropIndexFromRows(Index primaryIndex, Index oldIndex) {
        RowIterator it = primaryIndex.firstRow(this);
        int position = oldIndex.getPosition() - 1;
        while (it.hasNext()) {
            Row row = it.getNextRow();
            int i = position - 1;
            NodeAVL backnode = ((RowAVL)row).getNode(0);
            while (i-- > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
        it.release();
    }

    boolean insertIndexNodes(Session session, Index primaryIndex, Index newIndex) {
        int position = newIndex.getPosition();
        RowIterator it = primaryIndex.firstRow(this);
        int rowCount = 0;
        HsqlException error = null;
        try {
            while (it.hasNext()) {
                Row row = it.getNextRow();
                ((RowAVL)row).insertNode(position);
                ++rowCount;
                newIndex.insert(session, this, row);
            }
            it.release();
            return true;
        }
        catch (OutOfMemoryError e) {
            error = Error.error(460);
        }
        catch (HsqlException e) {
            error = e;
        }
        it = primaryIndex.firstRow(this);
        for (int i = 0; i < rowCount; ++i) {
            Row row = it.getNextRow();
            NodeAVL backnode = ((RowAVL)row).getNode(0);
            int j = position;
            while (--j > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
        it.release();
        throw error;
    }

    void destroy() {
        if (this.indexList.length == 0) {
            return;
        }
        IndexAVL idx = (IndexAVL)this.indexList[0];
        NodeAVL root = (NodeAVL)this.accessorList[0];
        idx.unlinkNodes(root);
    }
}

