/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;

public class TextFileSettings {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    Database database;
    String dataFileName;
    int maxCacheRows;
    int maxCacheBytes;
    static final byte[] BYTES_LINE_SEP = NL.getBytes();
    static final char DOUBLE_QUOTE_CHAR = '\"';
    static final char BACKSLASH_CHAR = '\\';
    static final char LF_CHAR = '\n';
    static final char CR_CHAR = '\r';

    TextFileSettings(Database database, String fileSettingsString) {
        this.database = database;
        HsqlProperties tableprops = HsqlProperties.delimitedArgPairsToProps(fileSettingsString, "=", ";", "textdb");
        HsqlDatabaseProperties dbProps = database.getProperties();
        switch (tableprops.errorCodes.length) {
            case 0: {
                this.dataFileName = null;
                break;
            }
            case 1: {
                this.dataFileName = tableprops.errorKeys[0].trim();
                break;
            }
            default: {
                throw Error.error(302);
            }
        }
        this.fs = dbProps.getStringProperty("textdb.fs");
        this.fs = tableprops.getProperty("textdb.fs", this.fs);
        this.vs = dbProps.getStringProperty("textdb.vs");
        this.vs = tableprops.getProperty("textdb.vs", this.vs);
        this.lvs = dbProps.getStringProperty("textdb.lvs");
        this.lvs = tableprops.getProperty("textdb.lvs", this.lvs);
        if (this.vs == null) {
            this.vs = this.fs;
        }
        if (this.lvs == null) {
            this.lvs = this.fs;
        }
        this.fs = TextFileSettings.translateSep(this.fs);
        this.vs = TextFileSettings.translateSep(this.vs);
        this.lvs = TextFileSettings.translateSep(this.lvs);
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Error.error(303);
        }
        this.ignoreFirst = dbProps.isPropertyTrue("textdb.ignore_first");
        this.ignoreFirst = tableprops.isPropertyTrue("textdb.ignore_first", this.ignoreFirst);
        this.isQuoted = dbProps.isPropertyTrue("textdb.quoted");
        this.isQuoted = tableprops.isPropertyTrue("textdb.quoted", this.isQuoted);
        this.isAllQuoted = dbProps.isPropertyTrue("textdb.all_quoted");
        this.isAllQuoted = tableprops.isPropertyTrue("textdb.all_quoted", this.isAllQuoted);
        this.stringEncoding = dbProps.getStringProperty("textdb.encoding");
        this.stringEncoding = tableprops.getProperty("textdb.encoding", this.stringEncoding);
        int cacheScale = dbProps.getIntegerProperty("textdb.cache_scale");
        cacheScale = tableprops.getIntegerProperty("textdb.cache_scale", cacheScale);
        int cacheSizeScale = dbProps.getIntegerProperty("textdb.cache_size_scale");
        cacheSizeScale = tableprops.getIntegerProperty("textdb.cache_size_scale", cacheSizeScale);
        this.maxCacheRows = (1 << cacheScale) * 3;
        this.maxCacheRows = dbProps.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheRows = tableprops.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheBytes = (1 << cacheSizeScale) * this.maxCacheRows / 1024;
        if (this.maxCacheBytes < 4) {
            this.maxCacheBytes = 4;
        }
        this.maxCacheBytes = dbProps.getIntegerProperty("textdb.cache_size", this.maxCacheBytes);
        this.maxCacheBytes = tableprops.getIntegerProperty("textdb.cache_size", this.maxCacheBytes);
        this.maxCacheBytes *= 1024;
    }

    String getFileName() {
        return this.dataFileName;
    }

    int getMaxCacheRows() {
        return this.maxCacheRows;
    }

    int getMaxCacheBytes() {
        return this.maxCacheBytes;
    }

    private static String translateSep(String sep) {
        return TextFileSettings.translateSep(sep, false);
    }

    private static String translateSep(String sep, boolean isProperty) {
        if (sep == null) {
            return null;
        }
        int next = sep.indexOf(92);
        if (next != -1) {
            int start = 0;
            char[] sepArray = sep.toCharArray();
            int ch = 0;
            int len = sep.length();
            StringBuffer sb = new StringBuffer(len);
            do {
                sb.append(sepArray, start, next - start);
                start = ++next;
                if (next >= len) {
                    sb.append('\\');
                    break;
                }
                if (!isProperty) {
                    ch = sepArray[next];
                }
                if (ch == 110) {
                    sb.append('\n');
                    ++start;
                    continue;
                }
                if (ch == 114) {
                    sb.append('\r');
                    ++start;
                    continue;
                }
                if (ch == 116) {
                    sb.append('\t');
                    ++start;
                    continue;
                }
                if (ch == 92) {
                    sb.append('\\');
                    ++start;
                    continue;
                }
                if (ch == 117) {
                    sb.append((char)Integer.parseInt(sep.substring(++start, start + 4), 16));
                    start += 4;
                    continue;
                }
                if (sep.startsWith("semi", next)) {
                    sb.append(';');
                    start += 4;
                    continue;
                }
                if (sep.startsWith("space", next)) {
                    sb.append(' ');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("quote", next)) {
                    sb.append('\"');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("apos", next)) {
                    sb.append('\'');
                    start += 4;
                    continue;
                }
                sb.append('\\');
                sb.append(sepArray[next]);
                ++start;
            } while ((next = sep.indexOf(92, start)) != -1);
            sb.append(sepArray, start, len - start);
            sep = sb.toString();
        }
        return sep;
    }
}

