/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputBinary
extends RowInputBase
implements RowInputInterface {
    public boolean ignoreDataErrors;
    private RowOutputBinary out;

    public RowInputBinary(byte[] buf) {
        super(buf);
    }

    public RowInputBinary(RowOutputBinary out) {
        super(out.getBuffer());
        this.out = out;
    }

    @Override
    public void readFully(byte[] b) {
        try {
            super.readFully(b);
        }
        catch (IOException e) {
            throw Error.error(e, 467, "RowInputBinary");
        }
    }

    @Override
    public long readLong() {
        try {
            return super.readLong();
        }
        catch (IOException e) {
            throw Error.error(e, 467, "RowInputBinary");
        }
    }

    @Override
    public int readInt() {
        try {
            return super.readInt();
        }
        catch (IOException e) {
            throw Error.error(e, 467, "RowInputBinary");
        }
    }

    @Override
    public short readShort() {
        try {
            return super.readShort();
        }
        catch (IOException e) {
            throw Error.error(e, 467, "RowInputBinary");
        }
    }

    @Override
    public char readChar() {
        try {
            return super.readChar();
        }
        catch (IOException e) {
            throw Error.error(e, 467, "RowInputBinary");
        }
    }

    @Override
    public byte readByte() {
        try {
            return super.readByte();
        }
        catch (IOException e) {
            throw Error.error(e, 467, "RowInputBinary");
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return super.readBoolean();
        }
        catch (IOException e) {
            throw Error.error(e, 467, "RowInputBinary");
        }
    }

    @Override
    public int readType() {
        return this.readShort();
    }

    @Override
    public String readString() {
        try {
            int length = this.readInt();
            if (length < 0) {
                throw Error.error(467, "RowInputBinary - negative length");
            }
            String s = StringConverter.readUTF(this.buffer, this.pos, length);
            s = ValuePool.getString(s);
            this.pos += length;
            return s;
        }
        catch (IOException e) {
            throw Error.error(e, 467, "RowInputBinary");
        }
    }

    @Override
    public boolean readNull() {
        byte b = this.readByte();
        return b == 0;
    }

    @Override
    protected String readChar(Type type) {
        return this.readString();
    }

    @Override
    protected Integer readSmallint() {
        return ValuePool.getInt(this.readShort());
    }

    @Override
    protected Integer readInteger() {
        return ValuePool.getInt(this.readInt());
    }

    @Override
    protected Long readBigint() {
        return ValuePool.getLong(this.readLong());
    }

    @Override
    protected Double readReal() {
        return ValuePool.getDouble(this.readLong());
    }

    @Override
    protected BigDecimal readDecimal(Type type) {
        byte[] bytes = this.readByteArray();
        int scale = this.readInt();
        BigInteger bigint = new BigInteger(bytes);
        return ValuePool.getBigDecimal(new BigDecimal(bigint, scale));
    }

    @Override
    protected Boolean readBoole() {
        return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected TimeData readTime(Type type) {
        if (type.typeCode == 92) {
            return new TimeData(this.readInt(), this.readInt(), 0);
        }
        return new TimeData(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    protected TimestampData readDate(Type type) {
        long date = this.readLong();
        return new TimestampData(date);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        if (type.typeCode == 93) {
            return new TimestampData(this.readLong(), this.readInt());
        }
        return new TimestampData(this.readLong(), this.readInt(), this.readInt());
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) {
        long months = this.readLong();
        return new IntervalMonthData(months, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) {
        long seconds = this.readLong();
        int nanos = this.readInt();
        return new IntervalSecondData(seconds, nanos, (IntervalType)type);
    }

    @Override
    protected Object readOther() {
        return new JavaObjectData(this.readByteArray());
    }

    @Override
    protected BinaryData readBit() {
        int length = this.readInt();
        byte[] b = new byte[(length + 7) / 8];
        this.readFully(b);
        return BinaryData.getBitData(b, length);
    }

    @Override
    protected BinaryData readBinary() {
        return new BinaryData(this.readByteArray(), false);
    }

    @Override
    protected ClobData readClob() {
        long id = this.readLong();
        return new ClobDataID(id);
    }

    @Override
    protected BlobData readBlob() {
        long id = this.readLong();
        return new BlobDataID(id);
    }

    @Override
    protected Object[] readArray(Type type) {
        type = type.collectionBaseType();
        int size = this.readInt();
        Object[] data = new Object[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readData(type);
        }
        return data;
    }

    public int[] readIntArray() throws IOException {
        int size = this.readInt();
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            if (this.readNull()) continue;
            data[i] = this.readInt();
        }
        return data;
    }

    @Override
    public Object[] readData(Type[] colTypes) {
        if (this.ignoreDataErrors) {
            return new Object[colTypes.length];
        }
        return super.readData(colTypes);
    }

    public byte[] readByteArray() {
        int length = this.readInt();
        byte[] b = new byte[length];
        this.readFully(b);
        return b;
    }

    public char[] readCharArray() throws IOException {
        int length = this.readInt();
        char[] c = new char[length];
        if (this.count - this.pos < c.length) {
            this.pos = this.count;
            throw new EOFException();
        }
        for (int i = 0; i < c.length; ++i) {
            int ch1 = this.buffer[this.pos++] & 0xFF;
            int ch2 = this.buffer[this.pos++] & 0xFF;
            c[i] = (char)((ch1 << 8) + ch2);
        }
        return c;
    }

    public void resetRow(int rowsize) {
        if (this.out != null) {
            this.out.reset(rowsize);
            this.buffer = this.out.getBuffer();
        }
        super.reset();
    }

    @Override
    public void resetRow(long filepos, int rowsize) {
        if (this.out != null) {
            this.out.reset(rowsize);
            this.buffer = this.out.getBuffer();
        }
        super.resetRow(filepos, rowsize);
    }
}

