/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;

public abstract class ScriptWriterBase
implements Runnable {
    Database database;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    HsqlNameManager.HsqlName schemaToLog;
    boolean isClosed;
    boolean isCompressed;
    boolean isCrypt;
    boolean isDump;
    boolean includeCachedData;
    boolean includeIndexRoots;
    long byteCount;
    long lineCount;
    volatile boolean needsSync;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    private Object timerTask;
    protected volatile int writeDelay = 60000;

    ScriptWriterBase(Database db, OutputStream outputStream, FileAccess.FileSync descriptor, boolean includeCachedData) {
        this.initBuffers();
        this.database = db;
        this.includeCachedData = includeCachedData;
        this.includeIndexRoots = !includeCachedData;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.fileStreamOut = new BufferedOutputStream(outputStream, 16384);
        this.outDescriptor = descriptor;
    }

    ScriptWriterBase(Database db, String file, boolean includeCachedData, boolean isNewFile, boolean isDump) {
        this.initBuffers();
        boolean exists = false;
        exists = isDump ? FileUtil.getFileUtil().exists(file) : db.logger.getFileAccess().isStreamElement(file);
        if (exists && isNewFile) {
            throw Error.error(452, file);
        }
        this.database = db;
        this.isDump = isDump;
        this.includeCachedData = includeCachedData;
        this.includeIndexRoots = !includeCachedData;
        this.outFile = file;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.openFile();
    }

    public void setIncludeIndexRoots(boolean include) {
        this.includeIndexRoots = include;
    }

    public void setIncludeCachedData(boolean include) {
        this.includeCachedData = include;
    }

    protected abstract void initBuffers();

    public void sync() {
        if (this.isClosed) {
            return;
        }
        if (this.needsSync) {
            this.forceSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSync() {
        if (this.isClosed) {
            return;
        }
        this.needsSync = false;
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                ++this.syncCount;
            }
            catch (IOException e) {
                this.database.logger.logWarningEvent("ScriptWriter synch error: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stop();
        if (this.isClosed) {
            return;
        }
        try {
            OutputStream outputStream = this.fileStreamOut;
            synchronized (outputStream) {
                this.finishStream();
                this.forceSync();
                this.fileStreamOut.close();
                this.fileStreamOut = null;
                this.outDescriptor = null;
                this.isClosed = true;
            }
        }
        catch (IOException e) {
            throw Error.error(452);
        }
        this.byteCount = 0L;
        this.lineCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() {
        try {
            this.writeDDL();
            this.writeExistingData();
        }
        catch (IOException e) {
            throw Error.error(452);
        }
    }

    protected void openFile() {
        try {
            FileUtil fa = this.isDump ? FileUtil.getFileUtil() : this.database.logger.getFileAccess();
            OutputStream fos = fa.openOutputStreamElement(this.outFile);
            this.outDescriptor = fa.getFileSync(fos);
            this.fileStreamOut = fos;
            this.fileStreamOut = new BufferedOutputStream(fos, 16384);
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new Object[]{e.toString(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
    }

    public void writeDDL() throws IOException {
        Result ddlPart = this.database.getScript(this.includeIndexRoots);
        this.writeSingleColumnResult(ddlPart);
    }

    public void writeExistingData() throws IOException {
        this.currentSession.loggedSchema = null;
        String[] schemas = this.database.schemaManager.getSchemaNamesArray();
        for (int i = 0; i < schemas.length; ++i) {
            String schema = schemas[i];
            Iterator tables = this.database.schemaManager.databaseObjectIterator(schema, 3);
            while (tables.hasNext()) {
                Table t = (Table)tables.next();
                boolean script = false;
                switch (t.getTableType()) {
                    case 4: {
                        script = true;
                        break;
                    }
                    case 5: {
                        script = this.includeCachedData;
                        break;
                    }
                    case 7: {
                        script = this.includeCachedData && !t.isDataReadOnly();
                    }
                }
                try {
                    if (!script) continue;
                    this.schemaToLog = t.getName().schema;
                    this.writeTableInit(t);
                    RowIterator it = t.rowIteratorClustered(this.currentSession);
                    while (it.hasNext()) {
                        Row row = it.getNextRow();
                        this.writeRow(this.currentSession, row, t);
                    }
                    this.writeTableTerm(t);
                }
                catch (Exception e) {
                    throw Error.error(452, e.toString());
                }
            }
        }
        this.writeDataTerm();
    }

    public void writeTableInit(Table t) throws IOException {
    }

    public void writeTableTerm(Table t) throws IOException {
    }

    protected void writeSingleColumnResult(Result r) throws IOException {
        RowSetNavigator nav = r.initialiseNavigator();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            this.writeLogStatement(this.currentSession, (String)data[0]);
        }
    }

    public abstract void writeRow(Session var1, Row var2, Table var3) throws IOException;

    protected abstract void writeDataTerm() throws IOException;

    protected abstract void writeSessionIdAndSchema(Session var1) throws IOException;

    public abstract void writeLogStatement(Session var1, String var2) throws IOException;

    public abstract void writeOtherStatement(Session var1, String var2) throws IOException;

    public abstract void writeInsertStatement(Session var1, Row var2, Table var3) throws IOException;

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3) throws IOException;

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2) throws IOException;

    public abstract void writeCommitStatement(Session var1) throws IOException;

    @Override
    public void run() {
        try {
            if (this.writeDelay != 0) {
                this.sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWriteDelay(int delay) {
        this.writeDelay = delay;
    }

    public void start() {
        if (this.writeDelay > 0) {
            this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, this.writeDelay, this, false);
        }
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

