/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.text.Collator;
import java.util.Locale;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Charset;

public class Collation
implements SchemaObject {
    static String defaultCollationName = "SQL_TEXT";
    static String defaultIgnoreCaseCollationName = "SQL_TEXT_UCC";
    public static final HashMap nameToJavaName = new HashMap(101);
    public static final HashMap dbNameToJavaName = new HashMap(101);
    public static final HashMap dbNameToCollation = new HashMap(11);
    static final Collation defaultCollation;
    static final Collation defaultIgnoreCaseCollation;
    final HsqlNameManager.HsqlName name;
    private Collator collator;
    private Locale locale;
    private boolean isUnicodeSimple;
    private boolean isUpperCaseCompare;
    private boolean isFinal;
    private boolean padSpace = true;
    private Charset charset;
    private HsqlNameManager.HsqlName sourceName;

    private Collation(boolean simple) {
        String nameString = simple ? defaultCollationName : defaultIgnoreCaseCollationName;
        this.locale = Locale.ENGLISH;
        this.name = HsqlNameManager.newInfoSchemaObjectName(nameString, false, 15);
        this.isUnicodeSimple = simple;
        this.isFinal = true;
    }

    private Collation(String name, String language, String country, int strength, int decomposition, boolean ucc) {
        this.locale = new Locale(language, country);
        this.collator = Collator.getInstance(this.locale);
        if (strength >= 0) {
            this.collator.setStrength(strength);
        }
        if (decomposition >= 0) {
            this.collator.setDecomposition(decomposition);
        }
        strength = this.collator.getStrength();
        this.isUnicodeSimple = false;
        this.name = HsqlNameManager.newInfoSchemaObjectName(name, true, 15);
        this.charset = Charset.SQL_TEXT;
        this.isUpperCaseCompare = ucc;
        this.isFinal = true;
    }

    public Collation(HsqlNameManager.HsqlName name, Collation source, Charset charset, Boolean padSpace) {
        this.name = name;
        this.locale = source.locale;
        this.collator = source.collator;
        this.isUnicodeSimple = source.isUnicodeSimple;
        this.isFinal = true;
        this.charset = charset;
        this.sourceName = source.name;
        if (padSpace != null) {
            this.padSpace = padSpace;
        }
    }

    public static Collation getDefaultInstance() {
        return defaultCollation;
    }

    public static Collation getDefaultIgnoreCaseInstance() {
        return defaultIgnoreCaseCollation;
    }

    public static Collation newDatabaseInstance() {
        Collation collation = new Collation(true);
        collation.isFinal = false;
        return collation;
    }

    public static Iterator getCollationsIterator() {
        return nameToJavaName.keySet().iterator();
    }

    public static Iterator getLocalesIterator() {
        return nameToJavaName.values().iterator();
    }

    public static synchronized Collation getCollation(String name) {
        Collation collation = (Collation)dbNameToCollation.get(name);
        if (collation != null) {
            return collation;
        }
        collation = Collation.getNewCollation(name);
        dbNameToCollation.put(name, collation);
        return collation;
    }

    public static synchronized Collation getUpperCaseCompareCollation(Collation source) {
        if (defaultCollationName.equals(source.name.name) || defaultIgnoreCaseCollationName.equals(source.name.name)) {
            return defaultIgnoreCaseCollation;
        }
        if (source.isUpperCaseCompare) {
            return source;
        }
        String name = source.getName().name;
        if (name.contains(" UCC")) {
            return source;
        }
        name = name + " UCC";
        return Collation.getCollation(name);
    }

    private static Collation getNewCollation(String name) {
        int strength = -1;
        int decomposition = -1;
        boolean ucc = false;
        String[] parts = StringUtil.split(name, " ");
        String dbName = parts[0];
        int index = 1;
        int limit = parts.length;
        if (parts.length > index && "UCC".equals(parts[limit - 1])) {
            ucc = true;
            --limit;
        }
        if (index < limit) {
            strength = Integer.parseInt(parts[index]);
            ++index;
        }
        if (index < limit) {
            decomposition = Integer.parseInt(parts[index]);
            ++index;
        }
        if (index < limit) {
            throw Error.error(5501, name);
        }
        String javaName = (String)dbNameToJavaName.get(dbName);
        if (javaName == null && (javaName = (String)nameToJavaName.get(dbName)) == null) {
            throw Error.error(5501, dbName);
        }
        parts = StringUtil.split(javaName, "-");
        String language = parts[0];
        String country = parts.length == 2 ? parts[1] : "";
        return new Collation(name, language, country, strength, decomposition, ucc);
    }

    public void setPadding(boolean padSpace) {
        if (this.isFinal) {
            throw Error.error(5503);
        }
        this.padSpace = padSpace;
    }

    public void setCollationAsLocale() {
        Locale locale = Locale.getDefault();
        String language = locale.getDisplayLanguage(Locale.ENGLISH);
        try {
            this.setCollation(language, false);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setCollation(String newName, Boolean padSpace) {
        if (this.isFinal) {
            throw Error.error(5503, newName);
        }
        Collation newCollation = Collation.getCollation(newName);
        this.name.rename(newCollation.name.name, true);
        this.locale = newCollation.locale;
        this.collator = newCollation.collator;
        this.isUnicodeSimple = newCollation.isUnicodeSimple;
        this.padSpace = padSpace;
    }

    public boolean isPadSpace() {
        return this.padSpace;
    }

    public boolean isUnicodeSimple() {
        return this.isUnicodeSimple;
    }

    public boolean isUpperCaseCompare() {
        return this.isUpperCaseCompare;
    }

    public boolean isCaseSensitive() {
        if (this.collator == null) {
            return this.isUnicodeSimple;
        }
        return !this.isUpperCaseCompare;
    }

    public int compare(String a, String b) {
        int i = this.collator == null ? (this.isUnicodeSimple ? a.compareTo(b) : a.compareToIgnoreCase(b)) : (this.isUpperCaseCompare ? this.collator.compare(this.toUpperCase(a), this.toUpperCase(b)) : this.collator.compare(a, b));
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    public String toUpperCase(String s) {
        return s.toUpperCase(this.locale);
    }

    public String toLowerCase(String s) {
        return s.toLowerCase(this.locale);
    }

    public boolean isDefaultCollation() {
        return this.collator == null && this.isUnicodeSimple & this.padSpace;
    }

    public boolean isObjectCollation() {
        return this.isFinal;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        sb.append("COLLATION").append(' ');
        if ("INFORMATION_SCHEMA".equals(this.name.schema.name)) {
            sb.append(this.name.getStatementName());
        } else {
            sb.append(this.name.getSchemaQualifiedStatementName());
        }
        sb.append(' ').append("FOR").append(' ');
        if ("INFORMATION_SCHEMA".equals(this.charset.name.schema.name)) {
            sb.append(this.charset.name.getStatementName());
        } else {
            sb.append(this.charset.name.getSchemaQualifiedStatementName());
        }
        sb.append(' ').append("FROM").append(' ');
        sb.append(this.sourceName.statementName);
        sb.append(' ');
        if (!this.padSpace) {
            sb.append("NO").append(' ').append("PAD");
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getCollateSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("COLLATE").append(' ');
        sb.append(this.getName().statementName);
        return sb.toString();
    }

    public String getDatabaseCollationSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ');
        sb.append("DATABASE").append(' ');
        sb.append("COLLATION").append(' ');
        sb.append(this.getName().statementName);
        sb.append(' ');
        if (!this.padSpace) {
            sb.append("NO").append(' ').append("PAD");
        }
        return sb.toString();
    }

    static {
        nameToJavaName.put("Afrikaans", "af-ZA");
        nameToJavaName.put("Amharic", "am-ET");
        nameToJavaName.put("Arabic", "ar");
        nameToJavaName.put("Assamese", "as-IN");
        nameToJavaName.put("Azerbaijani_Latin", "az-AZ");
        nameToJavaName.put("Azerbaijani_Cyrillic", "az-cyrillic");
        nameToJavaName.put("Belarusian", "be-BY");
        nameToJavaName.put("Bulgarian", "bg-BG");
        nameToJavaName.put("Bengali", "bn-IN");
        nameToJavaName.put("Tibetan", "bo-CN");
        nameToJavaName.put("Bosnian", "bs-BA");
        nameToJavaName.put("Catalan", "ca-ES");
        nameToJavaName.put("Czech", "cs-CZ");
        nameToJavaName.put("Welsh", "cy-GB");
        nameToJavaName.put("Danish", "da-DK");
        nameToJavaName.put("German", "de-DE");
        nameToJavaName.put("Greek", "el-GR");
        nameToJavaName.put("Latin1_General", "en-US");
        nameToJavaName.put("English", "en-US");
        nameToJavaName.put("Spanish", "es-ES");
        nameToJavaName.put("Estonian", "et-EE");
        nameToJavaName.put("Basque", "eu");
        nameToJavaName.put("Finnish", "fi-FI");
        nameToJavaName.put("French", "fr-FR");
        nameToJavaName.put("Guarani", "gn-PY");
        nameToJavaName.put("Gujarati", "gu-IN");
        nameToJavaName.put("Hausa", "ha-NG");
        nameToJavaName.put("Hebrew", "he-IL");
        nameToJavaName.put("Hindi", "hi-IN");
        nameToJavaName.put("Croatian", "hr-HR");
        nameToJavaName.put("Hungarian", "hu-HU");
        nameToJavaName.put("Armenian", "hy-AM");
        nameToJavaName.put("Indonesian", "id-ID");
        nameToJavaName.put("Igbo", "ig-NG");
        nameToJavaName.put("Icelandic", "is-IS");
        nameToJavaName.put("Italian", "it-IT");
        nameToJavaName.put("Inuktitut", "iu-CA");
        nameToJavaName.put("Japanese", "ja-JP");
        nameToJavaName.put("Georgian", "ka-GE");
        nameToJavaName.put("Kazakh", "kk-KZ");
        nameToJavaName.put("Khmer", "km-KH");
        nameToJavaName.put("Kannada", "kn-IN");
        nameToJavaName.put("Korean", "ko-KR");
        nameToJavaName.put("Konkani", "kok-IN");
        nameToJavaName.put("Kashmiri", "ks");
        nameToJavaName.put("Kirghiz", "ky-KG");
        nameToJavaName.put("Lao", "lo-LA");
        nameToJavaName.put("Lithuanian", "lt-LT");
        nameToJavaName.put("Latvian", "lv-LV");
        nameToJavaName.put("Maori", "mi-NZ");
        nameToJavaName.put("Macedonian", "mk-MK");
        nameToJavaName.put("Malayalam", "ml-IN");
        nameToJavaName.put("Mongolian", "mn-MN");
        nameToJavaName.put("Manipuri", "mni-IN");
        nameToJavaName.put("Marathi", "mr-IN");
        nameToJavaName.put("Malay", "ms-MY");
        nameToJavaName.put("Maltese", "mt-MT");
        nameToJavaName.put("Burmese", "my-MM");
        nameToJavaName.put("Danish_Norwegian", "nb-NO");
        nameToJavaName.put("Nepali", "ne-NP");
        nameToJavaName.put("Dutch", "nl-NL");
        nameToJavaName.put("Norwegian", "nn-NO");
        nameToJavaName.put("Oriya", "or-IN");
        nameToJavaName.put("Punjabi", "pa-IN");
        nameToJavaName.put("Polish", "pl-PL");
        nameToJavaName.put("Pashto", "ps-AF");
        nameToJavaName.put("Portuguese", "pt-PT");
        nameToJavaName.put("Romanian", "ro-RO");
        nameToJavaName.put("Russian", "ru-RU");
        nameToJavaName.put("Sanskrit", "sa-IN");
        nameToJavaName.put("Sindhi", "sd-IN");
        nameToJavaName.put("Slovak", "sk-SK");
        nameToJavaName.put("Slovenian", "sl-SI");
        nameToJavaName.put("Somali", "so-SO");
        nameToJavaName.put("Albanian", "sq-AL");
        nameToJavaName.put("Serbian_Cyrillic", "sr-YU");
        nameToJavaName.put("Serbian_Latin", "sh-BA");
        nameToJavaName.put("Swedish", "sv-SE");
        nameToJavaName.put("Swahili", "sw-KE");
        nameToJavaName.put("Tamil", "ta-IN");
        nameToJavaName.put("Telugu", "te-IN");
        nameToJavaName.put("Tajik", "tg-TJ");
        nameToJavaName.put("Thai", "th-TH");
        nameToJavaName.put("Turkmen", "tk-TM");
        nameToJavaName.put("Tswana", "tn-BW");
        nameToJavaName.put("Turkish", "tr-TR");
        nameToJavaName.put("Tatar", "tt-RU");
        nameToJavaName.put("Ukrainian", "uk-UA");
        nameToJavaName.put("Urdu", "ur-PK");
        nameToJavaName.put("Uzbek_Latin", "uz-UZ");
        nameToJavaName.put("Venda", "ven-ZA");
        nameToJavaName.put("Vietnamese", "vi-VN");
        nameToJavaName.put("Yoruba", "yo-NG");
        nameToJavaName.put("Chinese", "zh-CN");
        nameToJavaName.put("Zulu", "zu-ZA");
        Iterator it = nameToJavaName.values().iterator();
        while (it.hasNext()) {
            String javaName = (String)it.next();
            String dbName = javaName.replace('-', '_').toUpperCase(Locale.ENGLISH);
            dbNameToJavaName.put(dbName, javaName);
        }
        defaultCollation = new Collation(true);
        defaultIgnoreCaseCollation = new Collation(false);
        Collation.defaultCollation.charset = Charset.SQL_TEXT;
        Collation.defaultIgnoreCaseCollation.charset = Charset.SQL_TEXT;
        dbNameToCollation.put(defaultCollationName, defaultCollation);
        dbNameToCollation.put(defaultIgnoreCaseCollationName, defaultIgnoreCaseCollation);
    }
}

