/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public abstract class DTIType
extends Type {
    public static final byte[] yearToSecondSeparators = new byte[]{45, 45, 32, 58, 58, 46};
    public static final int[] yearToSecondFactors = new int[]{12, 1, 86400, 3600, 60, 1, 0};
    public static final int[] yearToSecondLimits = new int[]{0, 12, 0, 24, 60, 60, 1000000000};
    public static final int INTERVAL_MONTH_INDEX = 1;
    public static final int INTERVAL_SECOND_INDEX = 5;
    public static final int INTERVAL_FRACTION_PART_INDEX = 6;
    public static final long[] precisionLimits = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L};
    public static final int[] precisionFactors = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    public static final int[] nanoScaleFactors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    public static final int timezoneSecondsLimit = 50400;
    static final int[] intervalParts = new int[]{101, 102, 103, 104, 105, 106};
    static final int[][] intervalTypes = new int[][]{{101, 107, 0, 0, 0, 0}, {0, 102, 0, 0, 0, 0}, {0, 0, 103, 108, 109, 110}, {0, 0, 0, 104, 111, 112}, {0, 0, 0, 0, 105, 113}, {0, 0, 0, 0, 0, 106}};
    static final IntKeyIntValueHashMap intervalIndexMap = new IntKeyIntValueHashMap();
    public static final int TIMEZONE_HOUR = 257;
    public static final int TIMEZONE_MINUTE = 258;
    public static final int DAY_OF_WEEK = 259;
    public static final int DAY_OF_MONTH = 260;
    public static final int DAY_OF_YEAR = 261;
    public static final int WEEK_OF_YEAR = 262;
    public static final int QUARTER = 263;
    public static final int DAY_NAME = 264;
    public static final int MONTH_NAME = 265;
    public static final int SECONDS_MIDNIGHT = 266;
    public static final int ISO_YEAR = 267;
    public final int startIntervalType;
    public final int endIntervalType;
    public final int startPartIndex;
    public final int endPartIndex;
    public static final int defaultTimeFractionPrecision = 0;
    public static final int defaultTimestampFractionPrecision = 6;
    public static final int defaultIntervalPrecision = 2;
    public static final int defaultIntervalFractionPrecision = 6;
    public static final int maxIntervalPrecision = 9;
    public static final int maxIntervalSecondPrecision = 12;
    public static final int maxFractionPrecision = 9;
    public static final int limitNanoseconds = 1000000000;

    protected DTIType(int typeGroup, int type, long precision, int scale, int startIntervalType, int endIntervalType) {
        super(typeGroup, type, precision, scale);
        this.startIntervalType = startIntervalType;
        this.endIntervalType = endIntervalType;
        this.startPartIndex = intervalIndexMap.get(startIntervalType);
        this.endPartIndex = intervalIndexMap.get(endIntervalType);
    }

    protected DTIType(int typeGroup, int type, long precision, int scale) {
        super(typeGroup, type, precision, scale);
        switch (type) {
            case 91: {
                this.startIntervalType = 101;
                this.endIntervalType = 103;
                break;
            }
            case 92: 
            case 94: {
                this.startIntervalType = 104;
                this.endIntervalType = 106;
                break;
            }
            case 93: 
            case 95: {
                this.startIntervalType = 101;
                this.endIntervalType = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DTIType");
            }
        }
        this.startPartIndex = intervalIndexMap.get(this.startIntervalType);
        this.endPartIndex = intervalIndexMap.get(this.endIntervalType);
    }

    String intervalSecondToString(long seconds, int nanos, boolean signed) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        if (seconds < 0L) {
            seconds = -seconds;
            sb.append('-');
        } else if (signed) {
            sb.append('+');
        }
        for (i = this.startPartIndex; i <= this.endPartIndex; ++i) {
            int factor = yearToSecondFactors[i];
            long part = seconds / (long)factor;
            if (i == this.startPartIndex) {
                int startDigits = this.precision == 0L ? 2 : (int)this.precision;
                int zeros = startDigits - DTIType.getPrecisionExponent(part);
            } else if (part < 10L) {
                sb.append('0');
            }
            sb.append(part);
            seconds %= (long)factor;
            if (i >= this.endPartIndex) continue;
            sb.append((char)yearToSecondSeparators[i]);
        }
        if (this.scale != 0) {
            sb.append((char)yearToSecondSeparators[5]);
        }
        if (nanos < 0) {
            nanos = -nanos;
        }
        for (i = 0; i < this.scale; ++i) {
            int digit = nanos / precisionFactors[i];
            nanos -= digit * precisionFactors[i];
            sb.append(digit);
        }
        return sb.toString();
    }

    public int getStartIntervalType() {
        return this.startIntervalType;
    }

    public int getEndIntervalType() {
        return this.endIntervalType;
    }

    /*
     * Unable to fully structure code
     */
    public Type getExtractType(int part) {
        switch (part) {
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: {
                if (!this.isDateTimeType() || this.startIntervalType != 101) {
                    throw Error.error(5561);
                }
                if (part == 264 || part == 265) {
                    return Type.SQL_VARCHAR;
                }
                return Type.SQL_INTEGER;
            }
            case 106: {
                if (part != this.startIntervalType) ** GOTO lbl13
                if (this.scale != 0) {
                    return new NumberType(3, this.precision + (long)this.scale, this.scale);
                }
                ** GOTO lbl15
lbl13:
                // 1 sources

                if (part == this.endIntervalType && this.scale != 0) {
                    return new NumberType(3, 9 + this.scale, this.scale);
                }
            }
lbl15:
            // 4 sources

            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                if (part < this.startIntervalType || part > this.endIntervalType) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
            case 266: {
                if (!this.isDateTimeType() || this.endIntervalType < 106) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
            case 257: 
            case 258: {
                if (this.typeCode != 95 && this.typeCode != 94) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static int normaliseFraction(int fraction, int precision) {
        return fraction / nanoScaleFactors[precision] * nanoScaleFactors[precision];
    }

    static int getPrecisionExponent(long value) {
        int i;
        for (i = 1; i < precisionLimits.length && value >= precisionLimits[i]; ++i) {
        }
        return i;
    }

    public static int getFieldNameTypeForToken(int token) {
        switch (token) {
            case 323: {
                return 101;
            }
            case 173: {
                return 102;
            }
            case 73: {
                return 103;
            }
            case 127: {
                return 104;
            }
            case 169: {
                return 105;
            }
            case 250: {
                return 106;
            }
            case 283: {
                return 257;
            }
            case 284: {
                return 258;
            }
            case 671: {
                return 264;
            }
            case 708: {
                return 265;
            }
            case 722: {
                return 263;
            }
            case 672: {
                return 260;
            }
            case 673: {
                return 259;
            }
            case 674: {
                return 261;
            }
            case 791: {
                return 262;
            }
            case 735: {
                return 266;
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static String getFieldNameTokenForType(int type) {
        switch (type) {
            case 101: {
                return "YEAR";
            }
            case 102: {
                return "MONTH";
            }
            case 103: {
                return "DAY";
            }
            case 104: {
                return "HOUR";
            }
            case 105: {
                return "MINUTE";
            }
            case 106: {
                return "SECOND";
            }
            case 257: {
                return "TIMEZONE_HOUR";
            }
            case 258: {
                return "TIMEZONE_MINUTE";
            }
            case 264: {
                return "DAY_NAME";
            }
            case 265: {
                return "MONTH_NAME";
            }
            case 263: {
                return "QUARTER";
            }
            case 260: {
                return "DAY_OF_MONTH";
            }
            case 259: {
                return "DAY_OF_WEEK";
            }
            case 261: {
                return "DAY_OF_YEAR";
            }
            case 262: {
                return "WEEK_OF_YEAR";
            }
            case 266: {
                return "SECONDS_SINCE_MIDNIGHT";
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static boolean isValidDatetimeRange(Type a, Type b) {
        if (!a.isDateTimeType()) {
            return false;
        }
        if (b.isDateTimeType()) {
            return (a.typeCode != 92 || b.typeCode != 91) && (a.typeCode != 91 || b.typeCode != 92);
        }
        if (b.isIntervalType()) {
            return ((DateTimeType)a).canAdd((IntervalType)b);
        }
        return false;
    }

    public abstract int getPart(Session var1, Object var2, int var3);

    public abstract BigDecimal getSecondPart(Object var1);

    BigDecimal getSecondPart(long seconds, long nanos) {
        seconds *= precisionLimits[this.scale];
        return BigDecimal.valueOf(seconds += nanos / (long)nanoScaleFactors[this.scale], this.scale);
    }

    static {
        intervalIndexMap.put(101, 0);
        intervalIndexMap.put(102, 1);
        intervalIndexMap.put(103, 2);
        intervalIndexMap.put(104, 3);
        intervalIndexMap.put(105, 4);
        intervalIndexMap.put(106, 5);
    }
}

