/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericUtil {
    public static Class<?> getGenericClass(Class<?> clazz) {
        Type[] genericInterfaceTypes;
        for (Type genericInterfaceType : genericInterfaceTypes = clazz.getGenericInterfaces()) {
            if (!(genericInterfaceType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericInterfaceType;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return GenericUtil.getGenericClass(superClass);
        }
        return Object.class;
    }

    public static Class<?> getGenericClass(Object object) {
        Class<?> clazz = object.getClass();
        return GenericUtil.getGenericClass(clazz);
    }

    public static String getGenericClassName(Object object) {
        Class<?> clazz = GenericUtil.getGenericClass(object);
        return clazz.getName();
    }
}

