/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.reflect;

import com.liferay.petra.reflect.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Set;

public class ObjectGraphUtil {
    public static void walkObjectGraph(Object object, Visitor visitor) {
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.offer(object);
        Set visitedObjects = Collections.newSetFromMap(new IdentityHashMap());
        while ((object = queue.poll()) != null) {
            if (!visitedObjects.add(object)) continue;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                if ((clazz = clazz.getComponentType()).isPrimitive()) continue;
                for (int i = 0; i < Array.getLength(object); ++i) {
                    Object element = Array.get(object, i);
                    if (element == null) continue;
                    queue.offer(element);
                }
                continue;
            }
            while (clazz != null) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    try {
                        Object value = visitor.visit(field, object);
                        Class<?> type = field.getType();
                        if (value == null || type.isPrimitive()) continue;
                        queue.offer(value);
                    }
                    catch (Exception exception) {
                        ReflectionUtil.throwException(exception);
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    public static interface Visitor {
        public Object visit(Field var1, Object var2) throws Exception;
    }

    public static abstract class AnnotatedFieldMappingVisitor
    implements Visitor {
        private final Set<Class<? extends Annotation>> _annotationClasses;
        private final Set<Class<?>> _fieldTypeClasses;
        private final Set<Class<?>> _linkedClasses;

        public AnnotatedFieldMappingVisitor(Set<Class<?>> linkedClasses, Set<Class<? extends Annotation>> annotationClasses, Set<Class<?>> fieldTypeClasses) {
            this._linkedClasses = linkedClasses;
            this._annotationClasses = annotationClasses;
            this._fieldTypeClasses = fieldTypeClasses;
        }

        @Override
        public Object visit(Field field, Object target) throws Exception {
            Object value = field.get(target);
            if (value == null || !this.isLinkedClass(field.getDeclaringClass())) {
                return null;
            }
            if (!this.hasAnnotation(field.getAnnotations()) || !this.isFieldTypeClass(field.getType())) {
                return value;
            }
            field = ReflectionUtil.unfinalField(field);
            field.set(target, this.mapValue(field, value));
            return null;
        }

        protected abstract Object doMap(Field var1, Object var2);

        protected boolean hasAnnotation(Annotation[] annotations) {
            for (Annotation annotation : annotations) {
                for (Class<? extends Annotation> annotationClass : this._annotationClasses) {
                    if (!annotationClass.isInstance(annotation)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isFieldTypeClass(Class<?> clazz) {
            Class<?> componentType = clazz;
            for (Class<?> currentComponentType = clazz.getComponentType(); currentComponentType != null; currentComponentType = currentComponentType.getComponentType()) {
                componentType = currentComponentType;
            }
            for (Class<?> fieldTypeClass : this._fieldTypeClasses) {
                if (!fieldTypeClass.isAssignableFrom(componentType)) continue;
                return true;
            }
            return false;
        }

        protected boolean isLinkedClass(Class<?> clazz) {
            for (Class<?> linkedClass : this._linkedClasses) {
                if (!linkedClass.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }

        protected Object mapValue(Field field, Object value) {
            for (Class<?> fieldTypeClass : this._fieldTypeClasses) {
                if (!fieldTypeClass.isInstance(value)) continue;
                return this.doMap(field, value);
            }
            value = ReflectionUtil.arrayClone(value);
            for (int i = 0; i < Array.getLength(value); ++i) {
                Array.set(value, i, this.mapValue(field, Array.get(value, i)));
            }
            return value;
        }
    }
}

