/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.lar;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;

public class ExportImportPathUtil {
    public static final String PATH_PREFIX_COMPANY = "company";
    public static final String PATH_PREFIX_GROUP = "group";
    public static final String PATH_PREFIX_PORTLET = "portlet";
    public static final String PATH_PREFIX_SERVICE = "service";
    private static final String _FILE_EXTENSION_XML = ".xml";

    public static String getCompanyModelPath(long companyId, String className, long classPK) {
        return ExportImportPathUtil.getCompanyModelPath(companyId, className, Long.valueOf(classPK));
    }

    public static String getCompanyModelPath(long companyId, String className, Serializable classPK) {
        return ExportImportPathUtil.getModelPath(PATH_PREFIX_COMPANY, companyId, className, classPK, null);
    }

    public static String getExpandoPath(String path) {
        if (!Validator.isFilePath(path, false)) {
            throw new IllegalArgumentException("Unable to get expando path " + path + " because it is located outside of the LAR");
        }
        int pos = path.lastIndexOf(_FILE_EXTENSION_XML);
        if (pos == -1) {
            throw new IllegalArgumentException("Unable to get expando path " + path + " because it is not an XML file");
        }
        return StringBundler.concat((String[])new String[]{path.substring(0, pos), "-expando", path.substring(pos)});
    }

    public static String getModelPath(long groupId, String className, long classPK) {
        return ExportImportPathUtil.getModelPath(groupId, className, Long.valueOf(classPK));
    }

    public static String getModelPath(long groupId, String className, Serializable classPK) {
        return ExportImportPathUtil.getModelPath(PATH_PREFIX_GROUP, groupId, className, classPK, null);
    }

    public static String getModelPath(PortletDataContext portletDataContext, String className, long classPK) {
        return ExportImportPathUtil.getModelPath(portletDataContext, className, classPK, null);
    }

    public static String getModelPath(PortletDataContext portletDataContext, String className, long classPK, String dependentFileName) {
        return ExportImportPathUtil.getModelPath(PATH_PREFIX_GROUP, portletDataContext.getSourceGroupId(), className, Long.valueOf(classPK), dependentFileName);
    }

    public static String getModelPath(StagedModel stagedModel) {
        return ExportImportPathUtil.getModelPath(stagedModel, null);
    }

    public static String getModelPath(StagedModel stagedModel, String dependentFileName) {
        StagedModelType stagedModelType = stagedModel.getStagedModelType();
        if (stagedModel instanceof StagedGroupedModel) {
            StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)stagedModel;
            return ExportImportPathUtil.getModelPath(PATH_PREFIX_GROUP, stagedGroupedModel.getGroupId(), stagedModelType.getClassName(), stagedModel.getPrimaryKeyObj(), dependentFileName);
        }
        return ExportImportPathUtil.getModelPath(PATH_PREFIX_COMPANY, stagedModel.getCompanyId(), stagedModelType.getClassName(), stagedModel.getPrimaryKeyObj(), dependentFileName);
    }

    public static String getPortletDataPath(PortletDataContext portletDataContext) {
        return ExportImportPathUtil.getPortletDataPath(portletDataContext, portletDataContext.getPortletId(), portletDataContext.getPlid());
    }

    public static String getPortletDataPath(PortletDataContext portletDataContext, String portletId, long plid) {
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getPortletPath(portletDataContext, portletId));
        sb.append("/");
        Portlet portlet = PortletLocalServiceUtil.getPortletById(portletId);
        if (portlet.isPreferencesUniquePerLayout()) {
            sb.append(plid);
        } else {
            sb.append(portletDataContext.getScopeGroupId());
        }
        sb.append("/portlet-data.xml");
        return sb.toString();
    }

    public static String getPortletPath(PortletDataContext portletDataContext) {
        return ExportImportPathUtil.getPortletPath(portletDataContext, portletDataContext.getPortletId());
    }

    public static String getPortletPath(PortletDataContext portletDataContext, String portletId) {
        StringBundler sb = new StringBundler(5);
        sb.append(ExportImportPathUtil.getRootPath(portletDataContext));
        sb.append("/");
        sb.append(PATH_PREFIX_PORTLET);
        sb.append("/");
        sb.append(portletId);
        return sb.toString();
    }

    public static String getPortletPreferencesPath(PortletDataContext portletDataContext, String portletId, long ownerId, int ownerType, long plid) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getPortletPath(portletDataContext, portletId));
        sb.append("/preferences/");
        sb.append(ExportImportPathUtil.getOwnerTypePath(ownerType));
        sb.append(ownerId);
        sb.append('/');
        sb.append(plid);
        sb.append('/');
        sb.append("portlet-preferences.xml");
        return sb.toString();
    }

    public static String getRootPath(PortletDataContext portletDataContext) {
        return ExportImportPathUtil.getRootPath(PATH_PREFIX_GROUP, portletDataContext.getScopeGroupId());
    }

    public static String getServicePortletPreferencesPath(PortletDataContext portletDataContext, String serviceName, long ownerId, int ownerType) {
        StringBundler sb = new StringBundler(10);
        sb.append(ExportImportPathUtil.getRootPath(portletDataContext));
        sb.append("/");
        sb.append(PATH_PREFIX_SERVICE);
        sb.append("/");
        sb.append(serviceName);
        sb.append("/");
        sb.append(ExportImportPathUtil.getOwnerTypePath(ownerType));
        sb.append(ownerId);
        sb.append('/');
        sb.append("portlet-preferences.xml");
        return sb.toString();
    }

    public static String getSourceRootPath(PortletDataContext portletDataContext) {
        return ExportImportPathUtil.getRootPath(PATH_PREFIX_GROUP, portletDataContext.getSourceGroupId());
    }

    protected static String getModelPath(String pathPrefix, long pathPrimaryKey, String className, Serializable primaryKeyObj, String dependentFileName) {
        StringBundler sb = new StringBundler(7);
        sb.append(ExportImportPathUtil.getRootPath(pathPrefix, pathPrimaryKey));
        sb.append("/");
        sb.append(className);
        sb.append("/");
        sb.append(primaryKeyObj.toString());
        if (dependentFileName == null) {
            sb.append(_FILE_EXTENSION_XML);
        } else {
            sb.append("/");
            sb.append(dependentFileName);
        }
        return sb.toString();
    }

    protected static String getOwnerTypePath(int ownerType) {
        if (ownerType == 5) {
            return "archived/";
        }
        if (ownerType == 1) {
            return "company/";
        }
        if (ownerType == 2) {
            return "group/";
        }
        if (ownerType == 3) {
            return "layout/";
        }
        if (ownerType == 4) {
            return "user/";
        }
        return "";
    }

    protected static String getRootPath(String pathPrefix, long pathPrimaryKey) {
        StringBundler sb = new StringBundler(4);
        sb.append("/");
        sb.append(pathPrefix);
        sb.append("/");
        sb.append(pathPrimaryKey);
        return sb.toString();
    }
}

