/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.User;

public class UserLockoutException
extends PortalException {
    private UserLockoutException(String msg) {
        super(msg);
    }

    public static class PasswordPolicyLockout
    extends UserLockoutException {
        public final PasswordPolicy passwordPolicy;
        public final User user;

        public PasswordPolicyLockout(User user, PasswordPolicy passwordPolicy) {
            super(String.format("User %s was locked on %s by password policy %s and will be automatically unlocked on %s", user.getUserId(), user.getLockoutDate(), passwordPolicy.getName(), user.getUnlockDate(passwordPolicy)));
            this.user = user;
            this.passwordPolicy = passwordPolicy;
        }
    }

    public static class LDAPLockout
    extends UserLockoutException {
        public final String fullUserDN;
        public final String ldapMessage;

        public LDAPLockout(String fullUserDN, String ldapMessage) {
            super(String.format("User %s is locked out of a required LDAP server: %s", fullUserDN, ldapMessage));
            this.fullUserDN = fullUserDN;
            this.ldapMessage = ldapMessage;
        }
    }
}

