/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.proxy.BaseProxyBean;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.spring.aop.InvocationHandlerFactory;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class MessagingProxyInvocationHandler
implements InvocationHandler {
    private static final InvocationHandlerFactory _invocationHandlerFactory = new InvocationHandlerFactory(){

        @Override
        public InvocationHandler createInvocationHandler(Object object) {
            return new MessagingProxyInvocationHandler((BaseProxyBean)object);
        }
    };
    private final BaseProxyBean _baseProxyBean;

    public static Object createProxy(BaseProxyBean baseProxyBean) {
        Class<?> beanClass = baseProxyBean.getClass();
        Thread currentThread = Thread.currentThread();
        return ProxyUtil.newProxyInstance(currentThread.getContextClassLoader(), beanClass.getInterfaces(), new MessagingProxyInvocationHandler(baseProxyBean));
    }

    public static InvocationHandlerFactory getInvocationHandlerFactory() {
        return _invocationHandlerFactory;
    }

    public MessagingProxyInvocationHandler(BaseProxyBean baseProxyBean) {
        this._baseProxyBean = baseProxyBean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ProxyRequest proxyRequest = new ProxyRequest(method, args);
        if (proxyRequest.isSynchronous() || ProxyModeThreadLocal.isForceSync()) {
            return this._baseProxyBean.synchronousSend(proxyRequest);
        }
        this._baseProxyBean.send(proxyRequest);
        return null;
    }
}

