/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.welder;

import com.liferay.portal.kernel.nio.intraband.welder.Welder;
import com.liferay.portal.kernel.nio.intraband.welder.fifo.FIFOUtil;
import com.liferay.portal.kernel.nio.intraband.welder.fifo.FIFOWelder;
import com.liferay.portal.kernel.nio.intraband.welder.socket.SocketWelder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.Validator;

public class WelderFactoryUtil {
    private static final String _INTRABAND_WELDER_IMPL = GetterUtil.getString(System.getProperty("intraband.welder.impl"));

    public static Welder createWelder() {
        Class<? extends Welder> welderClass = WelderFactoryUtil.getWelderClass();
        try {
            return welderClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create Welder instance for class " + welderClass, exception);
        }
    }

    public static Class<? extends Welder> getWelderClass() {
        if (Validator.isNotNull(_INTRABAND_WELDER_IMPL)) {
            try {
                return Class.forName(_INTRABAND_WELDER_IMPL);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Unable to load class with name " + _INTRABAND_WELDER_IMPL, classNotFoundException);
            }
        }
        if (!OSDetector.isWindows() && FIFOUtil.isFIFOSupported()) {
            return FIFOWelder.class;
        }
        return SocketWelder.class;
    }
}

