/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.servlet.RequestDispatcherAttributeNames;
import com.liferay.portal.kernel.util.Mergeable;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RestrictPortletServletRequest
extends PersistentHttpServletRequestWrapper {
    private static final String[] _REQUEST_SHARED_ATTRIBUTES = PropsUtil.getArray("request.shared.attributes");
    private static final Log _log = LogFactoryUtil.getLog(RestrictPortletServletRequest.class);
    private static final Object _nullValue = new Object();
    private final Map<String, Object> _attributes = new HashMap<String, Object>();

    public static boolean isSharedRequestAttribute(String name) {
        for (String requestSharedAttribute : _REQUEST_SHARED_ATTRIBUTES) {
            if (!name.startsWith(requestSharedAttribute)) continue;
            return true;
        }
        return false;
    }

    public RestrictPortletServletRequest(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    public Object getAttribute(String name) {
        if (RequestDispatcherAttributeNames.contains(name)) {
            return super.getAttribute(name);
        }
        Object value = this._attributes.get(name);
        if (value == _nullValue) {
            return null;
        }
        if (value != null) {
            return value;
        }
        return super.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration superEnumeration = super.getAttributeNames();
        if (this._attributes.isEmpty()) {
            return superEnumeration;
        }
        HashSet names = new HashSet();
        while (superEnumeration.hasMoreElements()) {
            names.add(superEnumeration.nextElement());
        }
        for (Map.Entry<String, Object> entry : this._attributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == _nullValue) {
                names.remove(key);
                continue;
            }
            names.add(key);
        }
        return Collections.enumeration(names);
    }

    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    public void mergeSharedAttributes() {
        this.doMergeSharedAttributes(this.getRequest());
    }

    public void removeAttribute(String name) {
        if (RequestDispatcherAttributeNames.contains(name)) {
            super.removeAttribute(name);
        } else {
            this._attributes.put(name, _nullValue);
        }
    }

    public void setAttribute(String name, Object value) {
        if (RequestDispatcherAttributeNames.contains(name)) {
            super.setAttribute(name, value);
        } else {
            if (value == null) {
                value = _nullValue;
            }
            this._attributes.put(name, value);
        }
    }

    protected void doMergeSharedAttributes(ServletRequest servletRequest) {
        for (Map.Entry<String, Object> entry : this._attributes.entrySet()) {
            String name = entry.getKey();
            this.doMergeSharedAttributes(servletRequest, name, entry.getValue());
        }
    }

    protected void doMergeSharedAttributes(ServletRequest servletRequest, String name, Object value) {
        if (RestrictPortletServletRequest.isSharedRequestAttribute(name)) {
            if (value == _nullValue) {
                servletRequest.removeAttribute(name);
                if (_log.isDebugEnabled()) {
                    _log.debug("Remove shared attribute " + name);
                }
            } else {
                Object masterValue = servletRequest.getAttribute(name);
                if (masterValue == null || !(value instanceof Mergeable)) {
                    servletRequest.setAttribute(name, value);
                    if (_log.isDebugEnabled()) {
                        _log.debug("Set shared attribute " + name);
                    }
                } else {
                    Mergeable masterMergeable = (Mergeable)masterValue;
                    Mergeable slaveMergeable = (Mergeable)value;
                    masterMergeable.merge(slaveMergeable);
                    if (_log.isDebugEnabled()) {
                        _log.debug("Merge shared attribute " + name);
                    }
                }
            }
        } else if (value != _nullValue && _log.isDebugEnabled()) {
            _log.debug("Ignore setting restricted attribute " + name);
        }
    }
}

