/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.Accessor;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@JSON
@ProviderType
public interface FileEntry
extends RepositoryEntry,
RepositoryModel<FileEntry> {
    public static final Accessor<FileEntry, Long> FILE_ENTRY_ID_ACCESSOR = new Accessor<FileEntry, Long>(){

        @Override
        public Long get(FileEntry fileEntry) {
            return fileEntry.getFileEntryId();
        }

        @Override
        public Class<Long> getAttributeClass() {
            return Long.class;
        }

        @Override
        public Class<FileEntry> getTypeClass() {
            return FileEntry.class;
        }
    };

    public boolean containsPermission(PermissionChecker var1, String var2) throws PortalException;

    @Override
    public long getCompanyId();

    @JSON(include=false)
    public InputStream getContentStream() throws PortalException;

    public InputStream getContentStream(String var1) throws PortalException;

    @Override
    public Date getCreateDate();

    public String getDescription();

    public String getExtension();

    public long getFileEntryId();

    public String getFileName();

    public List<FileShortcut> getFileShortcuts();

    public FileVersion getFileVersion() throws PortalException;

    public FileVersion getFileVersion(String var1) throws PortalException;

    public List<FileVersion> getFileVersions(int var1);

    public int getFileVersionsCount(int var1);

    public Folder getFolder();

    public long getFolderId();

    @Override
    public long getGroupId();

    public String getIcon();

    public String getIconCssClass();

    public FileVersion getLatestFileVersion() throws PortalException;

    public FileVersion getLatestFileVersion(boolean var1) throws PortalException;

    public Lock getLock();

    public String getMimeType();

    public String getMimeType(String var1);

    @Override
    public Date getModifiedDate();

    public long getReadCount();

    public <T extends Capability> T getRepositoryCapability(Class<T> var1);

    public long getRepositoryId();

    public long getSize();

    public String getTitle();

    @Override
    public long getUserId();

    @Override
    public String getUserName();

    @Override
    public String getUserUuid();

    @Override
    public String getUuid();

    public String getVersion();

    public boolean hasLock();

    public boolean isCheckedOut();

    public boolean isDefaultRepository();

    public boolean isInTrash();

    public boolean isInTrashContainer();

    public boolean isManualCheckInRequired();

    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> var1);

    public boolean isSupportsLocking();

    public boolean isSupportsMetadata();

    public boolean isSupportsSocial();
}

