/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.FieldArray;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Field
implements Serializable {
    public static final String ANY = "*";
    public static final String ARTICLE_ID = "articleId";
    public static final String ASSET_CATEGORY_ID = "assetCategoryId";
    public static final String ASSET_CATEGORY_IDS = "assetCategoryIds";
    public static final String ASSET_CATEGORY_TITLE = "assetCategoryTitle";
    public static final String ASSET_CATEGORY_TITLES = "assetCategoryTitles";
    public static final String ASSET_INTERNAL_CATEGORY_ID = "assetInternalCategoryId";
    public static final String ASSET_INTERNAL_CATEGORY_IDS = "assetInternalCategoryIds";
    public static final String ASSET_INTERNAL_CATEGORY_TITLE = "assetInternalCategoryTitle";
    public static final String ASSET_INTERNAL_CATEGORY_TITLES = "assetInternalCategoryTitles";
    public static final String ASSET_PARENT_CATEGORY_ID = "parentCategoryId";
    public static final String ASSET_PARENT_CATEGORY_IDS = "parentCategoryIds";
    public static final String ASSET_TAG_IDS = "assetTagIds";
    public static final String ASSET_TAG_NAMES = "assetTagNames";
    public static final String ASSET_VOCABULARY_ID = "assetVocabularyId";
    public static final String ASSET_VOCABULARY_IDS = "assetVocabularyIds";
    public static final String CAPTION = "caption";
    public static final String CATEGORY_ID = "categoryId";
    public static final String CLASS_NAME_ID = "classNameId";
    public static final String CLASS_PK = "classPK";
    public static final String CLASS_TYPE_ID = "classTypeId";
    public static final String COMMENTS = "comments";
    public static final String COMPANY_ID = "companyId";
    public static final String CONTENT = "content";
    public static final String CREATE_DATE = "createDate";
    public static final String DEFAULT_LANGUAGE_ID = "defaultLanguageId";
    public static final String DESCRIPTION = "description";
    public static final String DISPLAY_DATE = "displayDate";
    public static final String ENTRY_CLASS_NAME = "entryClassName";
    public static final String ENTRY_CLASS_PK = "entryClassPK";
    public static final String EXPIRATION_DATE = "expirationDate";
    public static final String FOLDER_ID = "folderId";
    public static final String GEO_LOCATION = "geoLocation";
    public static final String GROUP_ID = "groupId";
    public static final String GROUP_ROLE_ID = "groupRoleId";
    public static final String HIDDEN = "hidden";
    public static final String KEYWORD_SEARCH = "keywordSearch";
    public static final String[] KEYWORDS = new String[]{"assetCategoryTitles", "assetTagNames", "comments", "content", "description", "properties", "title", "url", "userName"};
    public static final String LANGUAGE_ID = "languageId";
    public static final String LAYOUT_UUID = "layoutUuid";
    public static final String MODIFIED_DATE = "modified";
    public static final String NAME = "name";
    public static final String NODE_ID = "nodeId";
    public static final String ORGANIZATION_ID = "organizationId";
    public static final String PRIORITY = "priority";
    public static final String PROPERTIES = "properties";
    public static final String PUBLISH_DATE = "publishDate";
    public static final String RELATED_ENTRY = "relatedEntry";
    public static final String REMOVED_BY_USER_NAME = "removedByUserName";
    public static final String REMOVED_DATE = "removedDate";
    public static final String ROLE_ID = "roleId";
    public static final String ROLE_IDS = "roleIds";
    public static final String ROOT_ENTRY_CLASS_NAME = "rootEntryClassName";
    public static final String ROOT_ENTRY_CLASS_PK = "rootEntryClassPK";
    public static final String SCOPE_GROUP_ID = "scopeGroupId";
    public static final String SNIPPET = "snippet";
    public static final String SORTABLE_FIELD_SUFFIX = "sortable";
    public static final String SPELL_CHECK_WORD = "spellCheckWord";
    public static final String STAGING_GROUP = "stagingGroup";
    public static final String STATUS = "status";
    public static final String SUBTITLE = "subtitle";
    public static final String TITLE = "title";
    public static final String TREE_PATH = "treePath";
    public static final String TYPE = "type";
    public static final String UID = "uid";
    public static final String[] UNSCORED_FIELD_NAMES = new String[]{"assetCategoryIds", "companyId", "entryClassName", "entryClassPK", "folderId", "groupId", "groupRoleId", "roleId", "scopeGroupId", "userId"};
    public static final String URL = "url";
    public static final String USER_GROUP_ID = "userGroupId";
    public static final String USER_ID = "userId";
    public static final String USER_NAME = "userName";
    public static final String VERSION = "version";
    public static final String VIEW_ACTION_ID = "viewActionId";
    private static final String _SORTABLE_FIELD_SUFFIX = "sortable";
    private static final String _UID_FIELD = "_FIELD_";
    private static final String _UID_PORTLET = "_PORTLET_";
    private Date[] _dates;
    private final List<Field> _fields = new ArrayList<Field>();
    private GeoLocationPoint _geoLocationPoint;
    private Map<Locale, String> _localizedValues;
    private String _name;
    private boolean _numeric;
    private Class<? extends Number> _numericClass;
    private Field _parentField;
    private boolean _sortable;
    private boolean _tokenized;
    private String[] _values;

    public static String getLocalizedName(Locale locale, String name) {
        if (locale == null) {
            return name;
        }
        String languageId = LocaleUtil.toLanguageId(locale);
        return Field.getLocalizedName(languageId, name);
    }

    public static String getLocalizedName(String languageId, String name) {
        return LocalizationUtil.getLocalizedName(name, languageId);
    }

    public static String getSortableFieldName(String name) {
        return StringBundler.concat((String[])new String[]{name, "_", "sortable"});
    }

    public static String getSortFieldName(Sort sort, String scoreFieldName) {
        if (sort.getType() == 0) {
            return scoreFieldName;
        }
        String fieldName = sort.getFieldName();
        if (Field.isSortableFieldName(fieldName)) {
            return fieldName;
        }
        if (sort.getType() == 3 && !DocumentImpl.isSortableTextField(fieldName)) {
            return scoreFieldName;
        }
        return Field.getSortableFieldName(fieldName);
    }

    public static String getUID(String portletId, String field1) {
        return Field.getUID(portletId, field1, null);
    }

    public static String getUID(String portletId, String field1, String field2) {
        return Field.getUID(portletId, field1, field2, null);
    }

    public static String getUID(String portletId, String field1, String field2, String field3) {
        return Field.getUID(portletId, field1, field2, field3, null);
    }

    public static String getUID(String portletId, String field1, String field2, String field3, String field4) {
        String uid = portletId + _UID_PORTLET + field1;
        if (field2 != null) {
            uid = uid + _UID_FIELD + field2;
        }
        if (field3 != null) {
            uid = uid + _UID_FIELD + field3;
        }
        if (field4 != null) {
            uid = uid + _UID_FIELD + field4;
        }
        return uid;
    }

    public static boolean isSortableFieldName(String name) {
        return name.endsWith("sortable");
    }

    public static boolean validateFieldName(String name) {
        return !name.contains(",") && !name.contains(".") && !name.contains("#") && !name.contains("/") && !name.contains(ANY) && !name.startsWith("_");
    }

    public Field(String name) {
        this.validate(name);
        this._name = name;
    }

    public Field(String name, Map<Locale, String> localizedValues) {
        this.validate(name);
        this._name = name;
        this._localizedValues = localizedValues;
    }

    public Field(String name, String value) {
        this(name, new String[]{value});
    }

    public Field(String name, String[] values) {
        this.validate(name);
        this._name = name;
        this._values = values;
    }

    public void addField(Field field) {
        this._fields.add(field);
    }

    public Date[] getDates() {
        return this._dates;
    }

    public List<Field> getFields() {
        return this._fields;
    }

    public GeoLocationPoint getGeoLocationPoint() {
        return this._geoLocationPoint;
    }

    public Map<Locale, String> getLocalizedValues() {
        return this._localizedValues;
    }

    public String getName() {
        return this._name;
    }

    public Class<? extends Number> getNumericClass() {
        return this._numericClass;
    }

    public Field getParentField() {
        return this._parentField;
    }

    public String getValue() {
        if (ArrayUtil.isNotEmpty(this._values)) {
            return this._values[0];
        }
        return null;
    }

    public String[] getValues() {
        return this._values;
    }

    public boolean hasChildren() {
        return !this.getFields().isEmpty();
    }

    public boolean isArray() {
        return false;
    }

    public boolean isDate() {
        return this._dates != null;
    }

    public boolean isLocalized() {
        return this._localizedValues != null;
    }

    public boolean isNested() {
        return this.getParentField() != null;
    }

    public boolean isNumeric() {
        return this._numeric;
    }

    public boolean isSortable() {
        return this._sortable;
    }

    public boolean isTokenized() {
        return this._tokenized;
    }

    public void setDates(Date[] dates) {
        this._dates = dates;
    }

    public void setGeoLocationPoint(GeoLocationPoint geoLocationPoint) {
        this._geoLocationPoint = geoLocationPoint;
        if (geoLocationPoint == null) {
            this._values = null;
        } else {
            this.setValue(StringBundler.concat((Object[])new Object[]{"lat: ", geoLocationPoint.getLatitude(), ", lon: ", geoLocationPoint.getLongitude()}));
        }
    }

    public void setLocalizedValues(Map<Locale, String> localizedValues) {
        this._localizedValues = localizedValues;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setNumeric(boolean numeric) {
        this._numeric = numeric;
    }

    public void setNumericClass(Class<? extends Number> numericClass) {
        this._numericClass = numericClass;
    }

    public void setParentField(Field parentField) {
        this._parentField = parentField;
    }

    public void setSortable(boolean sortable) {
        this._sortable = sortable;
    }

    public void setTokenized(boolean tokenized) {
        this._tokenized = tokenized;
    }

    public void setValue(String value) {
        this.setValues(new String[]{value});
    }

    public void setValues(String[] values) {
        this._values = values;
    }

    protected void validate(String name) {
        if (name.contains(",")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Name must not contain ", ",", ": ", name}));
        }
        if (name.contains(".")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Name must not contain ", ".", ": ", name}));
        }
        if (name.contains("#")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Name must not contain ", "#", ": ", name}));
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Name must not contain ", "/", ": ", name}));
        }
        if (name.contains(ANY)) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Name must not contain ", ANY, ": ", name}));
        }
        if (name.startsWith("_")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Name must not start with ", "_", ": ", name}));
        }
    }

    public static class NestedFieldBuilder {
        private final LinkedList<Field> _nestedFieldsBuilderFields = new LinkedList();

        public NestedFieldBuilder addNestedField(String name, String ... values) {
            Field field = new Field(name);
            field.addField(new Field("value", values));
            this._addField(field);
            return this;
        }

        public NestedFieldBuilder endArray() {
            return this.endField();
        }

        public NestedFieldBuilder endField() {
            if (this._nestedFieldsBuilderFields.size() > 1) {
                this._nestedFieldsBuilderFields.removeLast();
            }
            return this;
        }

        public Field getField() {
            if (!this._nestedFieldsBuilderFields.isEmpty()) {
                return this._nestedFieldsBuilderFields.getLast();
            }
            return null;
        }

        public NestedFieldBuilder startArray(String name) {
            FieldArray fieldArray = new FieldArray(name);
            return this._startField(fieldArray);
        }

        public NestedFieldBuilder startField() {
            return this.startField(null);
        }

        public NestedFieldBuilder startField(String name) {
            Field field = new Field(name);
            return this._startField(field);
        }

        private void _addField(Field field) {
            Field lastField = this._nestedFieldsBuilderFields.getLast();
            lastField.addField(field);
        }

        private NestedFieldBuilder _startField(Field field) {
            if (!this._nestedFieldsBuilderFields.isEmpty()) {
                this._addField(field);
            }
            this._nestedFieldsBuilderFields.add(field);
            return this;
        }
    }
}

