/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth.session;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManager;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthenticatedSessionManagerUtil {
    private static final AuthenticatedSessionManagerUtil _authenticatedSessionManagerUtil = new AuthenticatedSessionManagerUtil();
    private final ServiceTracker<?, AuthenticatedSessionManager> _serviceTracker;

    public static AuthenticatedSessionManager getAuthenticatedSessionManager() {
        return (AuthenticatedSessionManager)AuthenticatedSessionManagerUtil._authenticatedSessionManagerUtil._serviceTracker.getService();
    }

    public static long getAuthenticatedUserId(HttpServletRequest httpServletRequest, String login, String password, String authType) throws PortalException {
        return AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().getAuthenticatedUserId(httpServletRequest, login, password, authType);
    }

    public static void login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String login, String password, boolean rememberMe, String authType) throws Exception {
        AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().login(httpServletRequest, httpServletResponse, login, password, rememberMe, authType);
    }

    public static void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().logout(httpServletRequest, httpServletResponse);
    }

    public static HttpSession renewSession(HttpServletRequest httpServletRequest, HttpSession session) throws Exception {
        return AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().renewSession(httpServletRequest, session);
    }

    public static void signOutSimultaneousLogins(long userId) throws Exception {
        AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().signOutSimultaneousLogins(userId);
    }

    private AuthenticatedSessionManagerUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(AuthenticatedSessionManager.class);
        this._serviceTracker.open();
    }
}

